using System;
using Gtk;
using GtkExtra;

namespace Kurush
{

public class BalanceSheetFrame : ReportFrame
{

    public BalanceSheetFrame (FrameManager owner) : base (owner)
    {
        Title = "Balance Sheet";
        MenuVisible = false;

        Refresh ();
    }

    public override void Refresh ()
    {
        Owner.DataBase.CalcDatedBalances (endingDate);

        Report report = new Report (Kurush.PrConfig, 4, 10.0);
        report.HeaderUser = Owner.DataBase.Title;
        report.HeaderTitle = "Balance Sheet";
        report.HeaderDate = Format.Value (endingDate);
        report.Columns[1].Width = 3;
        report.Columns[1].Align = Report.Alignment.Right;
        report.Columns[2].Width = 3;
        report.Columns[2].Align = Report.Alignment.Right;
        report.Columns[3].Width = 3;
        report.Columns[3].Align = Report.Alignment.Right;

        report.Open ();

        Data.Group group = Owner.DataBase.Groups[(int) Data.AccountType.Asset];
        report.Add ("ASSETS", "", "", Format.Value (group.DatedBalance));
        report.AddSpace (1);
        foreach (Data.Account account in group.Children)
        {
            report.Add (account.Name, "", Format.Value (account.DatedGroupBalance));
        }
        report.AddSpace (1);

        decimal liability =  Owner.DataBase.Groups[(int) Data.AccountType.Liability].DatedBalance;
        decimal equity =  Owner.DataBase.Groups[(int) Data.AccountType.Equity].DatedBalance;
        decimal income =  Owner.DataBase.Groups[(int) Data.AccountType.Income].DatedBalance;
        decimal expense =  Owner.DataBase.Groups[(int) Data.AccountType.Expense].DatedBalance;

        report.Add ("LIABILITIES & EQUITY", "", "",
                    Format.Value (liability + equity + income - expense));
        report.AddSpace (1);

        group = Owner.DataBase.Groups[(int) Data.AccountType.Liability];
        report.Add ("LIABILITIES", "", Format.Value (group.DatedBalance));
        report.AddSpace (1);
        foreach (Data.Account account in group.Children)
        {
            report.Add (account.Name, Format.Value (account.DatedGroupBalance));
        }
        report.AddSpace (1);

        group = Owner.DataBase.Groups[(int) Data.AccountType.Equity];
        report.Add ("EQUITY", "", Format.Value (equity + income - expense));
        report.AddSpace (1);
        foreach (Data.Account account in group.Children)
        {
            report.Add (account.Name, Format.Value (account.DatedGroupBalance));
        }
        report.Add ("Profit (Loss)", Format.Value (income - expense));

        report.Close ();
        printPreview.Job = report;
    }
}

}
