using System;
using GtkExtra;

namespace Kurush
{

public class SummaryReport
{
    public SummaryReport (Data.Base dataBase)
    {
        DateTime endingDate = DateTime.Today;

        Report report = new Report (Kurush.PrConfig, 3, 10.0);

        report.ShowColumnTitles = true;
        report.Columns[0].Title = "Account";
        report.Columns[0].Width = 6;
        report.Columns[1].Title = "Description";
        report.Columns[2].Title = "Balance";
        report.Columns[2].Width = 3;
        report.Columns[2].Align = Report.Alignment.Right;

        report.HeaderUser = dataBase.Title;
        report.HeaderTitle = "Account List";
        report.HeaderDate = Format.Value (endingDate);

        report.Open ();

        foreach (Data.Group group in dataBase.Groups)
        {
            report.Add (group.Name.ToUpper (), "", Format.Value (group.Balance));

            foreach (Data.Account account in group.Children)
            {
                report.Add (account.Name, account.Description, Format.Value (account.Balance));
            }
            report.AddSpace (1);
        }

        report.Close ();
        report.Print ();
    }
}

}
