using System;
using Gtk;
using GtkExtra;

namespace Kurush
{

public class SummaryView : TreeViewEx
{
    static GLib.GType gtype = GLib.GType.Invalid;
    public static new GLib.GType GType
    {
        get
        {
            if (gtype == GLib.GType.Invalid)
                gtype = RegisterGType (typeof (SummaryView));
            return gtype;
        }
    }


    public SummaryView (NodeStore store, bool headers) : base (store)
    {
        Selection.Mode = SelectionMode.Browse;
        HeadersVisible = headers;

        CellRendererText accountRenderer = new CellRendererText ();
        TreeViewColumn columnAccount =
            AppendColumn ("Account", accountRenderer,
                          "text", SummaryNode.Columns.Name);
        columnAccount.Resizable = true;
        columnAccount.AddAttribute (accountRenderer,
                                    "weight",
                                    (int) SummaryNode.Columns.Weight);

        SearchColumn = (int) SummaryNode.Columns.Name;
        EnableSearch = true;

        if (headers)
        {
            RulesHint = true;

            CellRendererText descriptionRenderer = new CellRendererText ();
            TreeViewColumn columnDescription =
                AppendColumn ("Description", descriptionRenderer,
                              "text", SummaryNode.Columns.Description);
            columnDescription.Resizable = true;
            columnDescription.AddAttribute (descriptionRenderer,
                                            "weight",
                                            (int) SummaryNode.Columns.Weight);

            CellRendererText balanceRenderer = new CellRendererText ();
            balanceRenderer.Xalign = 1.0F;
            balanceRenderer.Xpad = 4;
            TreeViewColumn columnBalance =
                AppendColumn ("Balance", balanceRenderer,
                              "text", SummaryNode.Columns.Balance);
            columnBalance.Resizable = true;
            columnBalance.Alignment = 1.0F;
            columnBalance.AddAttribute (balanceRenderer,
                                        "weight",
                                        (int) SummaryNode.Columns.Weight);
        }
    }


}

}
