#ifndef _KVI_EVENT_H_INCLUDED_
#define _KVI_EVENT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_event.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_fileutils.h"
#include "kvi_settings.h"
#include "kvi_string.h"

#ifdef COMPILE_PLUGIN_SUPPORT

#include "kvi_plugin.h"

typedef bool (*KviPluginEventHandler) (KviPluginCommandStruct *);
typedef struct KviPluginEventHandlerStruct
{
	KviPluginEventHandler  handler_routine;
	void                  *plugin_handle;
};
#endif

typedef struct KviEventDescriptor
{
	const char *eventName;
	const char *eventParams;
};

#define KviEvent_OnStartup                   0
#define KviEvent_OnShutdown                  1
#define KviEvent_OnServerPing                2
#define KviEvent_OnConnect                   3
#define KviEvent_OnDisconnect                4
#define KviEvent_OnIrc                       5
#define KviEvent_OnJoin                      6
#define KviEvent_OnChannelSync               7
#define KviEvent_OnMeJoin                    8
#define KviEvent_OnPart                      9
#define KviEvent_OnMePart                   10
#define KviEvent_OnKick                     11
#define KviEvent_OnMeKick                   12
#define KviEvent_OnTopic                    13
#define KviEvent_OnInvite                   14

#define KviEvent_OnCTCP                     15
#define KviEvent_OnCTCPReply                16
#define KviEvent_OnCTCPFlood                17
#define KviEvent_OnAction                   18

#define KviEvent_OnOp                       19
#define KviEvent_OnDeop                     20
#define KviEvent_OnMeOp                     21
#define KviEvent_OnMeDeop                   22

#define KviEvent_OnVoice                    23
#define KviEvent_OnDevoice                  24
#define KviEvent_OnMeVoice                  25
#define KviEvent_OnMeDevoice                26

#define KviEvent_OnBan                      27
#define KviEvent_OnUnban                    28
#define KviEvent_OnMeBan                    29
#define KviEvent_OnMeUnban                  30

#define KviEvent_OnBanException             31
#define KviEvent_OnBanExceptionRemove       32
#define KviEvent_OnMeBanException           33
#define KviEvent_OnMeBanExceptionRemove     34

#define KviEvent_OnChannelMode              35

#define KviEvent_OnChannelMessage           36
#define KviEvent_OnMePrivateMessage         37

#define KviEvent_OnServerNotice             38
#define KviEvent_OnChannelNotice            39
#define KviEvent_OnMeNotice                 40

#define KviEvent_OnNotify                   41

#define KviEvent_OnInviteException          42
#define KviEvent_OnInviteExceptionRemove    43
#define KviEvent_OnMeInviteException        44
#define KviEvent_OnMeInviteExceptionRemove  45

#define KviEvent_OnConsoleInput             46
#define KviEvent_OnChannelInput             47
#define KviEvent_OnQueryInput               48
#define KviEvent_OnDCCInput                 49

#define KviEvent_OnUnhandledLiteral         50
#define KviEvent_OnUnhandledNumeric         51

#define KviEvent_OnKeyShortcut              52

#define KviEvent_OnNickDoubleClicked        53
#define KviEvent_OnUserWindowInput          54
#define KviEvent_OnUserWindowFileDrop       55
#define KviEvent_OnUserWindowSelected       56
#define KviEvent_OnWhoisReply               57

#define KviEvent_OnDccChatMessage           58
#define KviEvent_OnDccChatConnected         59
#define KviEvent_OnDccChatTerminated        60

#define KviEvent_OnDccGetTransferComplete   61
#define KviEvent_OnDccSendTransferComplete  62

#define KviEvent_OnCtcpMultimedia           63
#define KviEvent_OnWallops                  64

#define KviEvent_OnChannelOpNotice          65

#define KviEvent_OnUrl                      66

#define KviEvent_OnNick                     67
#define KviEvent_OnMeNick                   68

#define KviEvent_OnError                    69

#define KviEvent_OnEventError               70
#define KviEvent_OnQuit                     71

#define KviEvent_OnIdleStart                72
#define KviEvent_OnIdleStop                 73

#define KviEvent_OnLogin                    74 // TODO: use OnLogin in void KviFrame::loginToIrcServer()

#define KviEvent_OnHalfop                   75
#define KviEvent_OnDehalfop                 76
#define KviEvent_OnMeHalfop                 77
#define KviEvent_OnMeDehalfop               78

#define KviEvent_OnUserop                   79
#define KviEvent_OnDeuserop                 80
#define KviEvent_OnMeUserop                 81
#define KviEvent_OnMeDeuserop               82

#define KviEvent_OnOwner                    83
#define KviEvent_OnDeowner                  84
#define KviEvent_OnMeOwner                  85
#define KviEvent_OnMeDeowner                86

#define KVI_NUM_EVENTS                      87

class KviEventManager
{
	friend class KviUserParser;
	friend class KviEventEditor;
	friend class KviPluginManager;
public:
	KviEventManager();
	~KviEventManager();
public:
	static KviEventDescriptor m_eventDescriptor[KVI_NUM_EVENTS];

	KviStr m_szEventBuffer[KVI_NUM_EVENTS];
protected:
	bool   m_bEventEnabled[KVI_NUM_EVENTS];
#ifdef COMPILE_PLUGIN_SUPPORT
	QPtrList<KviPluginEventHandlerStruct> *m_pEventHandlerList[KVI_NUM_EVENTS];
#endif
public:
#ifdef COMPILE_PLUGIN_SUPPORT
	inline bool eventEnabled(int numEvent)
		{ return (m_bEventEnabled[numEvent] || (m_pEventHandlerList[numEvent] != 0)); }
#else
	inline bool eventEnabled(int numEvent)
		{ return m_bEventEnabled[numEvent]; }
#endif
	void disableEmptyHandlers();
	void cleanup();
	void setHandler(const char *evName, const char *buffer, bool bEnabled);
	bool load(const char *filename, KviStr &error);
	bool save(const char *filename);
	/**
	 * Returns -1 if the event name is not found.
	 */
	int indexOfEvent(const char *eventName);
};

#endif // _KVI_EVENT_H_INCLUDED_
