#ifndef _KVI_SLAVEIO_H_INCLUDED_
#define _KVI_SLAVEIO_H_INCLUDED_

// =============================================================================
//
//      --- kvi_slaveio.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qobject.h>
#include <qptrlist.h>

#include "kvi_string.h"

class KviFrame;
class KviProcess;
class KviUserParser;
class KviWindow;

typedef struct KviSlaveProcEntry
{
	KviProcess *proc;
	KviStr      commandline;

	unsigned long int uPid;

	bool        bRunsInSubshell;
	bool        bQuiet;
	KviStr      asyncCmd;
	bool        bAsyncCmd;
	KviStr      stdoutBuffer;
	KviStr      stderrBuffer;
	KviStr      magic;
	KviStr      window;
};

class KviSlaveIO : public QObject
{
	Q_OBJECT
public:
	KviSlaveIO(KviFrame *, KviUserParser *);
	~KviSlaveIO();
protected:
	KviFrame *m_pFrm;

	QPtrList<KviSlaveProcEntry> *m_pProcList;

	KviUserParser *m_pUserParser;
public:
	bool killProcess(unsigned long int pid);
	int killAll();

	KviSlaveProcEntry *findProcByPid(unsigned long int pid);
	KviSlaveProcEntry *findProcByPtr(KviProcess *proc);

	bool exec(const char *commandline, KviWindow *, bool bExecInSubshell = false, bool bQuiet = false, const char *asyncCmd = 0, const char *magic = 0);
	void outputProcessList(KviWindow *);
	bool writeProcess(KviSlaveProcEntry *, const char *buffer, int len);
protected slots:
	void procExited(KviProcess *proc);
	void procStdout(KviProcess *proc, char *buffer, int buflen);
	void procStderr(KviProcess *proc, char *buffer, int buflen);
};

#endif // _KVI_SLAVEIO_H_INCLUDED_
