// =============================================================================
//
//      --- kvi_error.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviError"

#define _KVI_ERROR_CPP_

#include <string.h>

#include "kvi_debug.h"
#include "kvi_locale.h"
#include "kvi_settings.h"

static const char *g_kviErrorStringTable[] = {
	_i19n_("No error"),                                                             // KVI_ERROR_NoError
	_i19n_("Unknown error"),                                                        // KVI_ERROR_UnknownError
	_i19n_("No child process: not started or killed before completing operation"),  // KVI_ERROR_NoChildProcess
	_i19n_("No host to resolve"),                                                   // KVI_ERROR_NoHostToResolve
	_i19n_("Host not found"),                                                       // KVI_ERROR_HostNotFound
	_i19n_("Valid name, but the host has no IP address"),                           // KVI_ERROR_ValidNameButNoIpAddress
	_i19n_("Unrecoverable nameserver error"),                                       // KVI_ERROR_UnrecoverableNameserverError
	_i19n_("Temporary DNS fault, try again"),                                       // KVI_ERROR_DnsTemporaryFault
	_i19n_("DNS query failed"),                                                     // KVI_ERROR_DnsQueryFailed
	_i19n_("Invalid IP address"),                                                   // KVI_ERROR_InvalidIpAddress
	_i19n_("Another connection in progress"),                                       // KVI_ERROR_AnotherConnectionInProgress
	_i19n_("Socket creation failed"),                                               // KVI_ERROR_SocketCreationFailed
	_i19n_("Async socket operation not supported (fcntl failed)"),                  // KVI_ERROR_AsyncSocketFailed
	_i19n_("Bad file descriptor"),                                                  // KVI_ERROR_BadFileDescriptor
	_i19n_("Out of address space"),                                                 // KVI_ERROR_OutOfAddressSpace
	_i19n_("Kernel networking panic"),                                              // KVI_ERROR_KernelNetworkingPanic
	_i19n_("Connection refused by remote host"),                                    // KVI_ERROR_ConnectionRefused
	_i19n_("Connection attempt timed out"),                                         // KVI_ERROR_ConnectionTimedOut
	_i19n_("Network is unreachable"),                                               // KVI_ERROR_NetworkUnreachable
	_i19n_("Remote end closed connection"),                                         // KVI_ERROR_RemoteEndClosedConnection
	_i19n_("You are not connected to a server"),                                    // KVI_ERROR_NotConnectedToServer
	_i19n_("Broken pipe"),                                                          // KVI_ERROR_BrokenPipe
	_i19n_("Cannot find a server to contact. Please select a server in the "\
	       "server options dialog."),                                               // KVI_ERROR_NoServerEntries
	_i19n_("Unable to lookup local socket name."),                                  // KVI_ERROR_GetsocknameFailed
	_i19n_("Invalid proxy address."),                                               // KVI_ERROR_InvalidProxyAddress
	_i19n_("Unrecognized proxy reply"),                                             // KVI_ERROR_UnrecognizedProxyReply
	_i19n_("Proxy connection rejected."),                                           // KVI_ERROR_ProxyConnectionRejected
	_i19n_("No acceptable authentication methods"),                                 // KVI_ERROR_ProxyNoAcceptableMethods
	_i19n_("Proxy authorisation failed"),                                           // KVI_ERROR_ProxyAuthFailed
	_i19n_("Proxy error: general socks failure"),                               // KVI_ERROR_ProxyReply01GeneralSOCKSFailure
	_i19n_("Proxy error: connection not allowed"),                              // KVI_ERROR_ProxyReply02ConnectionNotAllowed
	_i19n_("Proxy error: target network unreachable"),                          // KVI_ERROR_ProxyReply03NetworkUnreachable
	_i19n_("Proxy error: target host unreachable"),                             // KVI_ERROR_ProxyReply04HostUnreachable
	_i19n_("Proxy error: target host refused the connection"),                  // KVI_ERROR_ProxyReply05ConnectionRefused
	_i19n_("Proxy error: target connection failed: TTL Expired"),               // KVI_ERROR_ProxyReply06TTLExpired
	_i19n_("Proxy error: command not supported"),                               // KVI_ERROR_ProxyReply07CommandNotSupported
	_i19n_("Proxy error: address type not supported"),                          // KVI_ERROR_ProxyReply08AddressTypeNotSupported
	_i19n_("Proxy error: invalid address"),                                     // KVI_ERROR_ProxyReply09InvalidAddress
	_i19n_("Proxy error: 91: request failed"),                                  // KVI_ERROR_ProxyReply91RequestFailed
	_i19n_("Proxy error: 92: ident failed"),                                    // KVI_ERROR_ProxyReply92IdentFailed
	_i19n_("Proxy error: 93: ident not matching"),                              // KVI_ERROR_ProxyReply93IdentNotMatching
	_i19n_("This executable was compiled without sound support"),                   // KVI_ERROR_CompiledWithNoSound
	_i19n_("The soundcard device is already open"),                                 // KVI_ERROR_SoundCardAlreadyOpen
	_i19n_("Could not open the soundcard device (/dev/dsp)"),                       // KVI_ERROR_CanNotOpenDevDsp
	_i19n_("Could not initialize soundcard: unsupported format, channels "\
	       "number or sample rate"),                                                // KVI_ERROR_CanNotInitializeSoundCard
	_i19n_("Dummy: missing file name"),                                             // KVI_ERROR_MissingFileName
	_i19n_("Missing closing brace"),                                                // KVI_ERROR_MissingClosingBrace
	_i19n_("Unknown command"),                                                      // KVI_ERROR_UnknownCommand
	_i19n_("Missing variable name"),                                                // KVI_ERROR_MissingVariableName
	_i19n_("Unknown operator"),                                                     // KVI_ERROR_UnknownOperator
	_i19n_("Unknown identifier"),                                                   // KVI_ERROR_UnknownIdentifier
	_i19n_("Unknown function"),                                                     // KVI_ERROR_UnknownFunction
	_i19n_("Unexpected end of command"),                                            // KVI_ERROR_UnexpectedEndOfCommand
	_i19n_("Missing operator"),                                                     // KVI_ERROR_MissingOperator
	_i19n_("Missing window name"),                                                  // KVI_ERROR_MissingWindowName
	_i19n_("Window not found"),                                                     // KVI_ERROR_WindowNotFound
	_i19n_("Missing icon number"),                                                  // KVI_ERROR_MissingIconNumber
	_i19n_("Invalid option/switch"),                                                // KVI_ERROR_InvalidOption
	_i19n_("Cannot find external help data files, or cannot open it for reading.\n"\
		"Please check your installation"),                                          // KVI_ERROR_CannotFindHelpFiles
	_i19n_("No help available on that... try /HELP index"),                         // KVI_ERROR_NoHelpAvailable
	_i19n_("Could not open the file for reading"),                                  // KVI_ERROR_CannotOpenFileForReading
	_i19n_("Left operand is not a numeric value"),                                  // KVI_ERROR_LeftOperandIsNotANumber
	_i19n_("Right operand is not a numeric value"),                                 // KVI_ERROR_RightOperandIsNotANumber
	_i19n_("Left operand is undefined"),                                            // KVI_ERROR_LeftOperandIsUndefined
	_i19n_("Unbalanced parenthesis"),                                               // KVI_ERROR_ParenthesisMismatch
	_i19n_("Unexpected character"),                                                 // KVI_ERROR_UnexpectedCharacter
	_i19n_("Oops... Internal error?"),                                              // KVI_ERROR_InternalError
	_i19n_("Missing command after else"),                                           // KVI_ERROR_MissingCommandAfterElse
	_i19n_("Open parenthesis expected"),                                            // KVI_ERROR_OpenParenthesisExpected
	_i19n_("Missing command after while"),                                          // KVI_ERROR_MissingCommandAfterWhile
	_i19n_("Single string operand"),                                                // KVI_ERROR_SingleStringOperand
	_i19n_("Operand does not match operator"),                                      // KVI_ERROR_OperandDoesNotMatchOperator
	_i19n_("Division by zero"),                                                     // KVI_ERROR_DivisionByZero
	_i19n_("Unexpected end in string"),                                             // KVI_ERROR_UnexpectedEndInString
	_i19n_("Do without while"),                                                     // KVI_ERROR_DoWithoutWhile
	_i19n_("Command terminator expected"),                                          // KVI_ERROR_CommandTerminatorExpected
	_i19n_("Missing dialog type"),                                                  // KVI_ERROR_MissingDialogType
	_i19n_("Unknown dialog type"),                                                  // KVI_ERROR_UnknownDialogType
	_i19n_("Alias name expected"),                                                  // KVI_ERROR_AliasNameExpected
	_i19n_("Alias body expected"),                                                  // KVI_ERROR_AliasBodyExpected
	_i19n_("Missing channel name"),                                                 // KVI_ERROR_MissingChannelName
	_i19n_("Mode requires parameters"),                                             // KVI_ERROR_ModeRequiresParameters
	_i19n_("Open brace '{' expected"),                                              // KVI_ERROR_OpenBraceExpected
	_i19n_("Case, match, default command or end of switch expected"),               // KVI_ERROR_CaseDefaultMatchOrEndOfSwitchExpected
	_i19n_("Command expected after 'default'"),                                     // KVI_ERROR_CommandExpectedAfterDefault
	_i19n_("Command expected after 'case()'"),                                      // KVI_ERROR_CommandExpectedAfterCase
	_i19n_("End of switch expected after 'default' action"),                        // KVI_ERROR_EndOfSwitchExpectedAfterDefault
	_i19n_("Command expected after 'match()'"),                                     // KVI_ERROR_CommandExpectedAfterMatch
	_i19n_("NICK requires a nickname!"),                                            // KVI_ERROR_NickRequiresANick
	_i19n_("Popup menu item command definition expected"),                          // KVI_ERROR_PopupItemCommandExpected
	_i19n_("Item, popup or separator expected"),                                    // KVI_ERROR_ItemPopupOrSeparatorExpected
	_i19n_("Unknown popup"),                                                        // KVI_ERROR_UnknownPopup
	_i19n_("This is not a channel"),                                                // KVI_ERROR_ThisIsNotAChannel
	_i19n_("Missing target"),                                                       // KVI_ERROR_MissingTarget
	_i19n_("Who queries require nickname parameters"),                              // KVI_ERROR_WhoQueriesRequireANick
	_i19n_("Missing CTCP type"),                                                    // KVI_ERROR_MissingCtcpType
	_i19n_("This is not a query/channel"),                                          // KVI_ERROR_ThisIsNotAQueryNorChannel
	_i19n_("Log on/off required"),                                                  // KVI_ERROR_LogOnOffRequired
	_i19n_("Could not start logging in this window"),                             // KVI_ERROR_CannotStartLoggingInThisWindow
	_i19n_("Could not start logging."),                                             // KVI_ERROR_CannotStartLogging
	_i19n_("Could not start the DNS thread."),                                      // KVI_ERROR_CanNotStartDnsThread
	_i19n_("Unsupported DCC type"),                                                 // KVI_ERROR_UnsupportedDccType
	_i19n_("Missing user mask"),                                                    // KVI_ERROR_MissingMask
	_i19n_("User already registered"),                                              // KVI_ERROR_AlreadyRegistered
	_i19n_("Invalid registration mask: must be of type nick!user@host and "\
	       "can contain the '*' wildcard"),                                         // KVI_ERROR_InvalidRegistrationMask
	_i19n_("The registration dialog is open, please add/remove the user from "\
	       "that dialog, or close it before using this command"),                   // KVI_ERROR_RegistrationWillBeResetByDialog
	_i19n_("User not registered"),                                                  // KVI_ERROR_UserNotRegistered
	_i19n_("Cannot self-modify the alias while executing it"),                      // KVI_ERROR_AliasSelfModificationNotAllowed
	_i19n_("Cannot self-modify the popup while executing it"),                      // KVI_ERROR_PopupSelfModificationNotAllowed
	_i19n_("The file is not a valid KVIrc script"),                                 // KVI_ERROR_NotAValidScriptFile
	_i19n_("Invalid parameter, string length expected"),                            // KVI_ERROR_StringLengthExpected
	_i19n_("Invalid parameter, string index expected"),                             // KVI_ERROR_StringIndexExpected
	_i19n_("Missing timeout"),                                                      // KVI_ERROR_MissingTimeout
	_i19n_("No mime type matching"),                                                // KVI_ERROR_NoMimeTypeMatching
	_i19n_("No commandline specified for mimetype"),                                // KVI_ERROR_NoCommandlineForMimeType
	_i19n_("Missing timer name"),                                                   // KVI_ERROR_MissingTimerName
	_i19n_("Invalid timeout"),                                                      // KVI_ERROR_InvalidTimeout
	_i19n_("Invalid port"),                                                         // KVI_ERROR_InvalidPort
	_i19n_("No matching timers"),                                                   // KVI_ERROR_NoMatchingTimers
	_i19n_("Missing option name"),                                                  // KVI_ERROR_MissingOptionName
	_i19n_("No such option"),                                                       // KVI_ERROR_NoSuchOption
	_i19n_("Missing option value"),                                                 // KVI_ERROR_MissingOptionValue
	_i19n_("Invalid option type"),                                                  // KVI_ERROR_InvalidOptionType
	_i19n_("No alias with that name"),                                              // KVI_ERROR_NoAliasWithThatName
	_i19n_("Invalid range value"),                                                  // KVI_ERROR_InvalidRangeValue
	_i19n_("Missing commandline"),                                                  // KVI_ERROR_MissingCommandline
	_i19n_("Process start failed"),                                                 // KVI_ERROR_ProcessStartFailed
	_i19n_("Missing window operation"),                                             // KVI_ERROR_MissingWindowOperation
	_i19n_("Unknown window operation"),                                             // KVI_ERROR_UnknownWindowOperation
	_i19n_("This window has no text buffer"),                                       // KVI_ERROR_ThisWindowHasNoTextBuffer
	_i19n_("Window position X, Y Expected"),                                        // KVI_ERROR_WindowPositionXYExpected
	_i19n_("Window size expected"),                                                 // KVI_ERROR_WindowSizeExpected
	_i19n_("Unknown image format"),                                                 // KVI_ERROR_UnknownImageFormat
	_i19n_("Unable to save text buffer"),                                           // KVI_ERROR_UnableToSaveBuffer
	_i19n_("Missing nickname"),                                                     // KVI_ERROR_MissingNickname
	_i19n_("Unsigned integer expected"),                                            // KVI_ERROR_UnsignedIntegerExpected
	_i19n_("Config file path expected"),                                            // KVI_ERROR_ConfigFilePathExpected
	_i19n_("Invalid config type"),                                                  // KVI_ERROR_InvalidConfigType
	_i19n_("This window has no commandline input"),                                 // KVI_ERROR_ThisWindowHasNoCommandline
	_i19n_("Missing pitch"),                                                        // KVI_ERROR_MissingPitch
	_i19n_("Missing duration"),                                                     // KVI_ERROR_MissingDuration
	_i19n_("Channel not found"),                                                    // KVI_ERROR_ChannelNotFound
	_i19n_("Missing directory name"),                                               // KVI_ERROR_MissingDirName
	_i19n_("Unable to list directory contents"),                                    // KVI_ERROR_CannotListDirContents
	_i19n_("Invalid directory"),                                                    // KVI_ERROR_InvalidDirectory
	_i19n_("Cannot enter that directory"),                                          // KVI_ERROR_CannotEnterThatDirectory
	_i19n_("Missing pid"),                                                          // KVI_ERROR_MissingPid
	_i19n_("No such process"),                                                      // KVI_ERROR_NoSuchProcess
	_i19n_("Could not write to process"),                                           // KVI_ERROR_CannotWriteToProcess
	_i19n_("Invalid window name. You forgot the *."),                               // KVI_ERROR_InvalidWindowName
	_i19n_("Missing dictionary key"),                                               // KVI_ERROR_MissingDictionaryKey
	_i19n_("Missing dictionary name"),                                              // KVI_ERROR_MissingDictionaryName
	_i19n_("Plugin file path expected"),                                            // KVI_ERROR_PluginFilePathExpected
	_i19n_("Invalid plugin operation"),                                             // KVI_ERROR_InvalidPluginOperation
	_i19n_("No plugin support in this executable"),                                 // KVI_ERROR_NoPluginSupport
	_i19n_("No such plugin"),                                                       // KVI_ERROR_NoSuchPlugin
	_i19n_("Unable to load plugin"),                                                // KVI_ERROR_CannotLoadPlugin
	_i19n_("Could not execute plugin init routine"),                              // KVI_ERROR_CannotExecutePluginInitRoutine
	_i19n_("Missing parameter"),                                                    // KVI_ERROR_MissingParameter
	_i19n_("Invalid parameter"),                                                    // KVI_ERROR_InvalidParameter
	_i19n_("Invalid operation"),                                                    // KVI_ERROR_InvalidOperation
	_i19n_("Missing key"),                                                          // KVI_ERROR_MissingKey
	_i19n_("Missing section"),                                                      // KVI_ERROR_MissingSection
	_i19n_("Utoolbar command expected: button, separator, menu, update, clear"),    // KVI_ERROR_UtoolbarCommandExpected
	_i19n_("Missing command block to try"),                                         // KVI_ERROR_MissingCommandBlockToTry
	_i19n_("Could not open the file for writing"),                                  // KVI_ERROR_CannotOpenFileForWriting
	_i19n_("Missing object class"),                                                 // KVI_ERROR_MissingObjectClass
	_i19n_("Missing object name"),                                                  // KVI_ERROR_MissingObjectName
	_i19n_("Missing object parent"),                                                // KVI_ERROR_MissingObjectParent
	_i19n_("Unknown object class"),                                                 // KVI_ERROR_UnknownObjectClass
	_i19n_("Nonexistant parent object"),                                            // KVI_ERROR_NonexistantParentObject
	_i19n_("Object not found"),                                                     // KVI_ERROR_ObjectNotFound
	_i19n_("Missing object field name"),                                            // KVI_ERROR_MissingObjectField
	_i19n_("Missing object ID"),                                                    // KVI_ERROR_MissingObjectId
	_i19n_("Missing object event name"),                                            // KVI_ERROR_MissingObjectEventName
	_i19n_("No such object function"),                                              // KVI_ERROR_NoSuchObjectFunction
	_i19n_("Object function call failure"),                                         // KVI_ERROR_ObjectFunctionFailure
	_i19n_("Class already defined"),                                                // KVI_ERROR_ClassAlreadyDefined
	_i19n_("Event or Function keyword expected"),                                   // KVI_ERROR_EventOrFunctionKeywordExpected
	_i19n_("Invalid class override"),                                               // KVI_ERROR_InvalidClassOverride
	_i19n_("Variable or identifier expected"),                                      // KVI_ERROR_VariableOrIdentifierExpected
	_i19n_("Not connected"),                                                        // KVI_ERROR_NotConnected
	_i19n_("The object is not a socket"),                                           // KVI_ERROR_ObjectIsNotASocket
	_i19n_("The socket object has no connections to accept"),                       // KVI_ERROR_NoConnectionToAccept
	_i19n_("No text to find"),                                                      // KVI_ERROR_NoTextToFind
	_i19n_("No such Qt property"),                                                  // KVI_ERROR_NoSuchQtProperty
	_i19n_("The object is not a widget"),                                           // KVI_ERROR_ObjectIsNotAWidget
	_i19n_("Missing signal name"),                                                  // KVI_ERROR_MissingSignalName
	_i19n_("Missing slot name"),                                                    // KVI_ERROR_MissingSlotName
	_i19n_("Unsupported Qt property"),                                              // KVI_ERROR_UnsupportedQtProperty
	_i19n_("Missing URL"),                                                          // KVI_ERROR_MissingUrl
	_i19n_("Missing browser commandline: set it in the misc options dialog!"),      // KVI_ERROR_MissingBrowserCommandlineOption
	_i19n_("Object is not a popup menu"),                                           // KVI_ERROR_ObjectIsNotAPopup
	_i19n_("Missing hostname"),                                                     // KVI_ERROR_MissingHostname
	_i19n_("Missing services command"),                                             // KVI_ERROR_MissingServicesCommand
	_i19n_("Userhost queries require nickname parameters"),                         // KVI_ERROR_UserhostRequiresANick
	_i19n_("User command requires username, host, server, and "
	       "optionally, description"),                                              // KVI_ERROR_UserRequiresUHS
	_i19n_("DCC thread aborted"),                                                   // KVI_ERROR_DccThreadAborted
	// End
	0
};

const char *kvi_getErrorString(int errorNum)
{
	__range_valid(errorNum < KVI_ERROR_NUMBER_OF_ERRORS);
	if( errorNum < 0 ) {
		// Unhandled system errors (errno value not handled in switches)
#ifdef HAVE_STRERROR
		__debug_1arg("Negative error for us... strerr error %s", strerror(errorNum));
		return strerror(-errorNum);
#else
		__debug_1arg("Have no strerror, errorNum was %d", -errorNum);
		errorNum = KVI_ERROR_UnknownError;
#endif
	}
	return _i18n_translateNoText(g_kviErrorStringTable[errorNum]);
}
