// =============================================================================
//
//      --- kvi_splashscreen.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviSplashScreen"

#include <qlayout.h>
#include <qpixmap.h>

#include "kvi_application.h"
#include "kvi_debug.h"
#include "kvi_defines.h"
#include "kvi_label.h"
#include "kvi_locale.h"
#include "kvi_progress.h"
#include "kvi_splashscreen.h"
#include "kvi_string.h"

// ============ KviSplashScreen ============
KviSplashScreen::KviSplashScreen(const QPixmap &pix)
	: QFrame(0, 0, WStyle_Customize | WStyle_NoBorder)
{
	init(pix);
}

KviSplashScreen::KviSplashScreen()
	: QFrame(0, 0, WStyle_Customize | WStyle_Splash)
{
	QPixmap pix(256, 256); // Cool memory map :)
	init(pix);
}

void KviSplashScreen::init(const QPixmap &pix)
{
	setFrameStyle(QFrame::Panel | QFrame::Raised);

	QGridLayout *g = new QGridLayout(this, 4, 1, 3, 2);

	m_pPixLabel = new KviLabel("...", this);
	m_pPixLabel->setMinimumSize(pix.size());
	m_pPixLabel->setMaximumSize(pix.size());
	__range_invalid(pix.isNull());
	m_pPixLabel->setBackgroundColor(black);
	m_pPixLabel->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	m_pPixLabel->setPixmap(pix);
	m_pPixLabel->setAlignment(AlignCenter);
	g->addWidget(m_pPixLabel, 0, 0);

	QFrame *r = new QFrame(this);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	r->setMinimumHeight(r->frameWidth() << 1);
	g->addWidget(r, 1, 0);

	m_pLabel = new KviLabel(_CHAR_2_QSTRING(__tr("Initiating startup sequence...")), this);
	m_pLabel->setAlignment(AlignCenter);
	g->addWidget(m_pLabel, 2, 0);

	m_pProgress = new KviProgress(100, this);

	g->addWidget(m_pProgress, 3, 0);

	g->setResizeMode(QLayout::Fixed);
}

// ============ ~KviSplashScreen ============
KviSplashScreen::~KviSplashScreen()
{
	// Nothing here
}

void KviSplashScreen::showEvent(QShowEvent *e)
{
	move((qApp->desktop()->width()  - width())  >> 1,
	     (qApp->desktop()->height() - height()) >> 1);
}

void KviSplashScreen::setProgress(int progress)
{
	m_pProgress->setProgress(progress);
	m_pProgress->repaint(false);
	qApp->processEvents();
}

void KviSplashScreen::setText(const char *text)
{
	m_pLabel->setText(_CHAR_2_QSTRING(text));
}

#include "m_kvi_splashscreen.moc"
