#ifndef _KVI_TABDIALOG_QT_H_INCLUDED_
#define _KVI_TABDIALOG_QT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_tabdialog_qt.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qintdict.h>
#include <qtabdialog.h>

class QFrame;
class QGrid;
class QHBox;
class QVBox;

class KviTabDialog : public QTabDialog
{
	Q_OBJECT
public:
	enum ButtonCode {
		Ok     = 0x00000001,
		Help   = 0x00000002,
		Cancel = 0x00000004,
		Apply  = 0x00000008
	};

	KviTabDialog(
		QWidget *parent = 0, const char *name = 0, bool modal = true,
		const QString &caption = QString::null, int buttonMask = Ok | Help | Cancel
	);
	~KviTabDialog();

	QFrame *addPage(const QString &itemName);
	QGrid  *addGridPage(int numRows, Orientation, const QString &itemName);
	QHBox  *addHBoxPage(const QString &itemName);
	QVBox  *addVBoxPage(const QString &itemName);

	void delayedDestruct();

	int  activePageIndex();
	void showPage(int index);
	void showPageForWidget(QWidget *);

	void setButtonCancelText(const QString &text = QString::null);
	void setButtonDefaultText(const QString &text = QString::null);
	void setButtonHelpText(const QString &text = QString::null);
	void setButtonOKText(const QString &text = QString::null);
signals:
	void applyClicked();
	void cancelClicked();
	void helpClicked();
	void okClicked();
private:
	QIntDict<QWidget> m_pageIndex;

	void addNewPage(QWidget *, const QString &name);
};

#endif // _KVI_TABDIALOG_QT_H_INCLUDED_
