// =============================================================================
//
//      --- kvi_dcc_chatmessagebox.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviDccChatMessageBox"

#include "kvi_dcc_chatmessagebox.h"
#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_netutils.h"

// NOTE: uAddress in this file is in NETWORK BYTE ORDER.

KviDccChatMessageBox::KviDccChatMessageBox(
	KviFrame *parent, const char *nick, const char *username, const char *host,
	unsigned long uAddress, unsigned short uPort, bool bVoice)
	: KviMessageBox(
		bVoice ? _CHAR_2_QSTRING(__tr("DCC Voice Request")) : _CHAR_2_QSTRING(__tr("DCC Chat Request")),
		_CHAR_2_QSTRING(""),
		NoIcon,
		Yes | Default,
		No  | Escape,
		0, parent, 0, false
	  )
{
	m_nick     = nick;
	m_username = username;
	m_host     = host;
	m_uAddress = uAddress;
	m_uPort    = uPort;

	struct in_addr addr;
	addr.s_addr = uAddress;
	KviStr humanReadableAddr;

	kvi_binaryIpToString(addr, humanReadableAddr);

	KviStr tmp(KviStr::Format,
		__tr(
			"%s [%s@%s]\n"\
			"requests a Direct Client Connection in %s mode.\n"\
			"The remote DCC target host is %s on port %u\n"\
			"Do you wish to accept?"
		),
		nick, username, host,
		bVoice ? "VOICE" : "CHAT",
		humanReadableAddr.ptr(), uPort
	);
	setText(_CHAR_2_QSTRING(tmp.ptr()));
}

KviDccChatMessageBox::~KviDccChatMessageBox()
{
	// Nothing here
}

void KviDccChatMessageBox::done(int result)
{
	KviMessageBox::done(result);
	if( result == Yes ) {
		emit dccRequestAccepted(m_nick.ptr(), m_username.ptr(), m_host.ptr(), m_uAddress, m_uPort);
	}
}

#include "m_kvi_dcc_chatmessagebox.moc"
