// =============================================================================
//
//      --- kvi_mainmenu.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviMainMenu"

#include <qpainter.h>

#include "kvi_accel.h"
#include "kvi_app.h"
#include "kvi_frame.h"
#include "kvi_locale.h"
#include "kvi_maintoolbar.h"
#include "kvi_mdi_manager.h"
#include "kvi_mdi_toolbar.h"
#include "kvi_mainmenu.h"
#include "kvi_options.h"
#include "kvi_popupmenu.h"
#include "kvi_settings.h"
#include "kvi_statusbar.h"
#include "kvi_systray_bar.h"
#include "kvi_taskbar.h"
#include "kvi_usertoolbar.h"
#include "kvi_usertoolbartemplate.h"

extern KviUserToolBarTemplate *g_pUserToolBarTemplate;

/**
 * ============ KviMainMenu ============
 */
KviMainMenu::KviMainMenu(KviFrame *par)
	: KviMenuBar(par, "main_menu")
{
	m_pFrm = par;

	// Create the menu
	m_pMainPopup = new KviPopupMenu(this, "main_popup");
	m_pMainPopup->insertTearOffHandle();
	m_pMainPopup->setCaption(__tr("KVIrc"));
	m_pMainPopup->insertItem(__tr("&New Session"), g_pApp, SLOT(createNewFrame()), QAccel::stringToKey(__tr("Ctrl+N")));
	m_pMainPopup->insertSeparator();
	m_iConnectItemId = m_pMainPopup->insertItem(
		__tr("C&onnect"), m_pFrm, SLOT(slot_connectToServer()), QAccel::stringToKey(__tr("Shift+F2"))
	);
	m_pMainPopup->insertItem(__tr("Recent &Servers"), m_pFrm->m_pRecentServersPopup);
	m_pMainPopup->insertSeparator();
	m_iDockWidgetId = m_pMainPopup->insertItem(__tr("Show &Dock Icon"), g_pApp, SLOT(slot_createWMDockWidget()));
#ifndef COMPILE_NEED_KDE
	m_pMainPopup->setItemEnabled(m_iDockWidgetId, false);
#endif
	m_pMainPopup->insertSeparator();
	m_pMainPopup->insertItem(__tr("&Close Session"), m_pFrm, SLOT(close()),         QAccel::stringToKey(__tr("Ctrl+W")));
	m_pMainPopup->insertItem(__tr("&Quit KVIrc"),    g_pApp, SLOT(slot_safeQuit()), QAccel::stringToKey(__tr("Ctrl+Q")));

	KviPopupMenu *opts = new KviPopupMenu(this, "options_popup");
	opts->insertTearOffHandle();
	opts->setCaption(__tr("Options"));
	opts->insertItem(__tr("&User Configuration..."),     g_pApp, SLOT(slot_doUserOptionsDialog()));
	opts->insertItem(__tr("Servers && Proxy &Hosts..."), g_pApp, SLOT(slot_doServerOptionsDialog()));
	opts->insertItem(__tr("&General Options..."),        g_pApp, SLOT(slot_generalOptionsDialog()));
	opts->insertItem(__tr("&Registered Users..."),       g_pApp, SLOT(slot_doRegUsersDialog()));
	opts->insertSeparator();
	opts->insertItem(__tr("&Save Preferences"),          g_pApp, SLOT(slot_saveSettings()));

	m_pToolsPopup = new KviPopupMenu(this, "tools_popup");
	connect(m_pToolsPopup, SIGNAL(aboutToShow()), this, SLOT(fillToolsPopup()));

	m_pOnlinePopup = new KviPopupMenu(this, "online_popup");
	m_pOnlinePopup->insertTearOffHandle();
	m_pOnlinePopup->setCaption(__tr("Online"));
	m_pOnlinePopup->insertItem(__tr("Recent &Channels"),  m_pFrm->m_pRecentChannelsPopup);
	m_pOnlinePopup->insertItem(__tr("Recent &Nicknames"), m_pFrm->m_pRecentNicknamesPopup);
	m_pOnlinePopup->insertSeparator();
	m_pOnlinePopup->insertItem(__tr("Channel &List"), m_pFrm, SLOT(activateListWindow()));
	m_pOnlinePopup->insertItem(__tr("&Server Links"), m_pFrm, SLOT(slot_requestLinks()));

	KviPopupMenu *help = new KviPopupMenu(this, "help_popup");
	help->insertTearOffHandle();
	help->setCaption(__tr("Help"));
	help->insertItem(__tr("&Help Browser"),  m_pFrm, SLOT(toggleHelpBrowser()),      QAccel::stringToKey(__tr("Ctrl+F1")));
	help->insertItem(__tr("What is &This?"), m_pFrm, SLOT(slot_whatIsThisRequest()), QAccel::stringToKey(__tr("Shift+F1")));
	help->insertSeparator();
	help->insertItem(__tr("Tip of the &Day"), g_pApp, SLOT(slot_doTipOfTheDay()));
	help->insertSeparator();
	help->insertItem(__tr("&About KVIrc"), g_pApp, SLOT(slot_doAboutDialog()));

	insertItem(__tr("&KVIrc"),   m_pMainPopup);
	insertItem(__tr("&Options"), opts);
	insertItem(__tr("&Tools"),   m_pToolsPopup);
	m_iOnlinePopupId = insertItem(__tr("On&line"), m_pOnlinePopup);
	setItemEnabled(m_iOnlinePopupId, false);
	insertItem(__tr("&Window"),  m_pFrm->m_pMdi->getWindowMenu());
	insertItem(__tr("&Help"),    help);
#ifdef COMPILE_NEED_KDE
	if( g_pOptions->m_bEnableDockWidget )
		wmDockWidgetStateChanged(true);
#endif
	setBackgroundMode(PaletteBackground);
}

/**
 * ============ ~KviMainMenu ============
 */
void KviMainMenu::setBackgroundMode(BackgroundMode bk)
{
	if( g_pOptions->m_bUseThemeMenubarBackground ) {
		if( backgroundPixmap() && !backgroundPixmap()->isNull() )
			KviMenuBar::setBackgroundMode(bk);
	}
}

KviMainMenu::~KviMainMenu()
{
	if( m_pOnlinePopup ) {
		delete m_pOnlinePopup;
		m_pOnlinePopup = 0;
	}
}

void KviMainMenu::setConnectItemState(bool bIsOnline)
{
	QString text;
	if( bIsOnline )
		text = __tr("&Disconnect");
	else
		text = __tr("C&onnect");
	m_pMainPopup->changeItem(m_iConnectItemId, text);
}

void KviMainMenu::enableOnLinePopup(bool bEnable)
{
	m_pOnlinePopup->setEnabled(bEnable);
	setItemEnabled(m_iOnlinePopupId, bEnable);
}

void KviMainMenu::wmDockWidgetStateChanged(bool bIsVisible)
{
	m_pMainPopup->removeItem(m_iDockWidgetId);
	if( bIsVisible ) {
		m_iDockWidgetId = m_pMainPopup->insertItem(
			__tr("Hide Dock Icon"), g_pApp, SLOT(slot_destroyWMDockWidget()), 0, m_iDockWidgetId, 5
		);
		g_pOptions->m_bEnableDockWidget = true;
	} else {
		m_iDockWidgetId = m_pMainPopup->insertItem(
			__tr("Show Dock Icon"), g_pApp, SLOT(slot_createWMDockWidget()), 0, m_iDockWidgetId, 5
		);
		g_pOptions->m_bEnableDockWidget = false;
	}
}

void KviMainMenu::setBackgroundPixmap(const QPixmap &pm)
{
	KviMenuBar::setBackgroundPixmap(pm);
	setPalette(palette());
}

void KviMainMenu::setPalette(const QPalette &pal)
{
	if( !backgroundPixmap() ) {
		KviMenuBar::setPalette(pal);
		return;
	}

	if( !backgroundPixmap()->isNull() ) {
		QPalette    p = pal;
		QColorGroup g = p.active();
		g.setBrush(QColorGroup::Button, QBrush(NoBrush));
		p.setActive(g);
		g = p.disabled();
		g.setBrush(QColorGroup::Button, QBrush(NoBrush));
		p.setDisabled(g);
		KviMenuBar::setPalette(p);
		return;
	}
}

void KviMainMenu::drawContents(QPainter *p)
{
	// It is horrible, I know... but there is no other human way.
	const QPixmap *pix = backgroundPixmap();
	if( pix ) {
		if( !pix->isNull() ) {
			p->drawTiledPixmap(0, 0, width(), height(), *pix, 0, 0);
			KviMenuBar::drawContents(p);
			return;
		}
	}
	KviMenuBar::drawContents(p);
}

void KviMainMenu::fillToolsPopup()
{
	m_pToolsPopup->clear();
	m_pToolsPopup->insertTearOffHandle();
	m_pToolsPopup->setCaption(__tr("Tools"));
	int id = m_pToolsPopup->insertItem(
		__tr("&Script Center"), m_pFrm, SLOT(slot_showScriptCenter()), QAccel::stringToKey(__tr("Shift+F5"))
	);
	m_pToolsPopup->setItemEnabled(id, !g_pApp->scriptCenterDialogOpen());
	id = m_pToolsPopup->insertItem(__tr("&Directory Browser"), m_pFrm, SLOT(toggleDirBrowser()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->dirBrowserOpen());

	m_pToolsPopup->insertSeparator();

	m_pToolsPopup->insertItem(
		__tr("Save &Current Script..."), g_pApp, SLOT(slot_doScriptWizard()), QAccel::stringToKey(__tr("Ctrl+S"))
	);
	m_pToolsPopup->insertItem(
		__tr("Load Scri&pt..."), g_pApp, SLOT(slot_doLoadScriptDialog()), QAccel::stringToKey(__tr("Ctrl+L"))
	);

	m_pToolsPopup->insertSeparator();

	id = m_pToolsPopup->insertItem(__tr("Status&bar"), m_pFrm, SLOT(slot_toggleStatusBar()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pStatusBar->isVisible());
	id = m_pToolsPopup->insertItem(__tr("T&askbar"), m_pFrm, SLOT(slot_toggleTaskBar()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pTaskBar->isVisible());
	id = m_pToolsPopup->insertItem(__tr("T&oolbar"), m_pFrm, SLOT(slot_toggleToolBar()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pToolBar->isVisible());
	id = m_pToolsPopup->insertItem(__tr("&MDI Toolbar"), m_pFrm, SLOT(slot_toggleMdiToolBar()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pMdiToolBar->isVisible());
	id = m_pToolsPopup->insertItem(__tr("S&ystem Tray Bar"), m_pFrm, SLOT(slot_toggleSysTrayBar()));
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pSysTrayBar->isVisible());
	id = m_pToolsPopup->insertItem(__tr("&User Toolbar"), m_pFrm, SLOT(slot_toggleUserToolBar()));
	m_pToolsPopup->setItemEnabled(id, !g_pUserToolBarTemplate->isEmpty());
	m_pToolsPopup->setItemChecked(id, m_pFrm->m_pUserToolBar->isVisible());

	m_pToolsPopup->insertSeparator();

	m_pToolsPopup->insertItem(__tr("Arrange Toolbars (Normal)"),  m_pFrm, SLOT(slot_lineUpToolBarsNormal()));
	m_pToolsPopup->insertItem(__tr("Arrange Toolbars (Compact)"), m_pFrm, SLOT(slot_lineUpToolBarsCompact()));
}

#include "m_kvi_mainmenu.moc"
