// =============================================================================
//
//      --- kvi_tipoftheday.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Till Bush (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviTipOfTheDay"

#include <qcheckbox.h>

#include "kvi_app.h"
#include "kvi_fileutils.h"
#include "kvi_label.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_pushbutton.h"
#include "kvi_tipoftheday.h"

// From kvi_app.cpp
extern QPixmap *g_pixViewOut[KVI_OUT_NUM_IMAGES];

KviTipOfTheDay::KviTipOfTheDay()
	: KviDialog(0)
{
	setIcon(*g_pixViewOut[KVI_OUT_IDEA]);

	m_pLabel = new KviLabel(this);
	m_pLabel->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	m_pLabel->setMargin(5);
	m_pLabel->setAlignment(AlignCenter);

	KviStr szImage;
	QPixmap pix;

	if( g_pApp->findImage(szImage, "tipoftheday.png") ) {
		pix.load(szImage.ptr());
		m_pLabel->setBackgroundPixmap(pix);
		m_pLabel->setMinimumSize(pix.size());
	}

	QPalette pal(m_pLabel->palette());
	pal.setColor(QColorGroup::Text, QColor(130, 130, 255));
	pal.setColor(QColorGroup::Foreground, QColor(130, 130, 255));
	m_pLabel->setPalette(pal);

	m_pNext = new KviPushButton(__tr("Next"), this);
	connect(m_pNext, SIGNAL(clicked()), this, SLOT(doNextTip()));
	m_pNext->setDefault(false);

	m_pClose = new KviPushButton(__tr("Close"), this);
	connect(m_pClose, SIGNAL(clicked()), this, SLOT(accept()));
	m_pClose->setDefault(true);

	m_pCheck = new QCheckBox(__tr("Show tip at startup"), this);
	m_pCheck->setChecked(g_pOptions->m_bShowTipOfTheDayAtStartup);

	int iHint = m_pNext->sizeHint().height();
	QSize s(pix.width() + 8, pix.height() + 9 + iHint);
	setMinimumSize(s);

	setCaption(__tr("Did you know..."));

	KviStr szPath;
	KviStr localFileName = kvi_getLocaleName();

	// Try localized tips file
	localFileName.prepend("kvi.tip_");
	localFileName.append(".conf");

	g_pApp->getGlobalKVIrcDirectory(szPath, KviApp::Config, localFileName.ptr());
	// If it is not there, try the _en one
	if( !kvi_fileExists(szPath.ptr()) )
		g_pApp->getGlobalKVIrcDirectory(szPath, KviApp::Config, "kvi.tip_en.conf");
	// If it is not there, try the non-localized one
	if( !kvi_fileExists(szPath.ptr()) )
		g_pApp->getGlobalKVIrcDirectory(szPath, KviApp::Config, "kvi.tip.conf");

	kvi_loadFile(szPath.ptr(), m_szTips);

	if( m_szTips.isEmpty() ) {
		m_szTips = __tr("[TIP 0]\nDid you know\nthat KVIrc could not load the tips file?\n");
		g_pOptions->m_bShowTipOfTheDayAtStartup = false;
	}

	doNextTip();
	m_pClose->setFocus();
}

KviTipOfTheDay::~KviTipOfTheDay()
{
	// Nothing here
}

void KviTipOfTheDay::doNextTip()
{
	KviStr tmp1(KviStr::Format, "[TIP %d]", g_pOptions->m_iNextTipOfTheDayIdx);
	int idx = m_szTips.findFirstIdx(tmp1.ptr());
	if( idx == -1 ) {
		if( g_pOptions->m_iNextTipOfTheDayIdx == 0 ) {
			m_pLabel->setText(__tr("Did you know\nthat KVIrc has an empty tips file?"));
			return;
		}
		g_pOptions->m_iNextTipOfTheDayIdx = 0;
		doNextTip();
		return;
	}
	KviStr tmp = (const char *) (m_szTips.ptr() + idx);
	tmp.cutLeft(tmp1.len() + 1);
	idx = tmp.findFirstIdx('[');
	if( idx != -1 )
		tmp.cutRight(tmp.len() - idx);
	if( tmp.isEmpty() ) {
		g_pOptions->m_iNextTipOfTheDayIdx++;
		doNextTip();
		return;
	}
	m_pLabel->setText(tmp.ptr());
	g_pOptions->m_iNextTipOfTheDayIdx++;
}

void KviTipOfTheDay::resizeEvent(QResizeEvent *)
{
	int iHint = m_pNext->sizeHint().height();
	int iWdth = (width() - 11) / 4;
	m_pLabel->setGeometry(4, 4, width() - 8, height() - (9 + iHint));
	m_pCheck->setGeometry(4, height() - (4 + iHint), iWdth << 1, iHint);
	m_pNext->setGeometry(5 + (iWdth << 1), height() - (4 + iHint), iWdth, iHint);
	m_pClose->setGeometry(width() - (4 + iWdth), height() - (4 + iHint), iWdth, iHint);
}

void KviTipOfTheDay::done(int)
{
	g_pOptions->m_bShowTipOfTheDayAtStartup = m_pCheck->isChecked();
	emit closed();
}

void KviTipOfTheDay::closeEvent(QCloseEvent *)
{
	g_pOptions->m_bShowTipOfTheDayAtStartup = m_pCheck->isChecked();
	emit closed();
}

#include "m_kvi_tipoftheday.moc"
