// =============================================================================
//
//      --- kvi_messagetypes.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviMessageTypes"

#define _KVI_MESSAGETYPES_CPP_

#include "kvi_defines.h"
#include "kvi_locale.h"
#include "kvi_messagetypes.h"

// This must match the order of the KVI_OUT_* constants order
// (declared in kvi_defines.h)
const char *kvi_messagetypes[KVI_OUT_NUM_IMAGES + 2] =
{
	_i19n_("Normal text"),
	_i19n_("Internal messages"),
	_i19n_("Internal errors"),
	_i19n_("KVIrc logo text"),
	_i19n_("'Echoed' text"),
	_i19n_("Socket messages"),
	_i19n_("Server information"),
	_i19n_("Unhandled server replies"),
	_i19n_("Server message of the day"),
	_i19n_("Unhandled error messages"),
	_i19n_("Nickname error messages"),
	_i19n_("Server pings"),
	_i19n_("Join messages"),
	_i19n_("Topic changes"),
	_i19n_("Time messages"),
	_i19n_("Internal desync notices"),
	_i19n_("Names reply"),
	_i19n_("Part messages"),
	_i19n_("Kick messages"),
	_i19n_("Quit messages"),
	_i19n_("Quit on split messages"),
	_i19n_("Split warnings"),
	_i19n_("Own user mode changes"),
	_i19n_("Op messages"),
	_i19n_("Deop messages"),
	_i19n_("Voice messages"),
	_i19n_("Devoice messages"),
	_i19n_("Ban messages"),
	_i19n_("Unban messages"),
	_i19n_("Ban exception messages"),
	_i19n_("Ban unexception messages"),
	_i19n_("Key (mode +k) messages"),
	_i19n_("Limit (mode +l) messages"),
	_i19n_("Other channel mode messages"),
	_i19n_("Who replies"),
	_i19n_("Private messages not handled"),
	_i19n_("CTCP requests"),
	_i19n_("CTCP replies"),
	_i19n_("CTCP errors"),
	_i19n_("Raw text to server"),
	_i19n_("Own channel and query text"),
	_i19n_("Spam warnings"),
	_i19n_("Nick changes"),
	_i19n_("Flood warnings"),
	_i19n_("Actions"),
	_i19n_("Notices"),
	_i19n_("DNS results"),
	_i19n_("Notify list changes"),
	_i19n_("Highlighted text"),
	_i19n_("Invite messages"),
	_i19n_("DCC Info"),
	_i19n_("DCC Warnings"),
	_i19n_("DCC Errors"),
	_i19n_("Help text"),
	_i19n_("Process stdin"),
	_i19n_("Process stdout"),
	_i19n_("Process stderr"),
	_i19n_("Directory entries of /DIR"),
	_i19n_("File entries of /DIR"),
	_i19n_("Plugin output"),
	_i19n_("Happy text"),
	_i19n_("Unhappy text"),
	_i19n_("Angry text"),
	_i19n_("Kill text"),
	_i19n_("Killed text"),
	_i19n_("CTCP multimedia"),
	_i19n_("Wallops"),
	_i19n_("Log"),
	_i19n_("Idea"),
	_i19n_("Input"),
	_i19n_("Packet"),
	_i19n_("Talk"),
	_i19n_("Script"),
	_i19n_("Colors"),
	_i19n_("Op notices"),
	_i19n_("mIRC"),
	_i19n_("Widget"),
	_i19n_("Server errors"),
	_i19n_("Console"),
	_i19n_("Channel"),
	_i19n_("Query"),
	_i19n_("Chat"),
	_i19n_("Send"),
	_i19n_("Help browser"),
	_i19n_("Directory browser"),
	_i19n_("Voice"),
	_i19n_("Links"),
	_i19n_("List"),
	_i19n_("User window"),
	_i19n_("Halfop messages"),
	_i19n_("Dehalfop messages"),
	_i19n_("Userop messages"),
	_i19n_("Deuserop messages"),
	_i19n_("Owner messages"),
	_i19n_("Deowner messages"),
	// New message types go BEFORE THIS LINE!
	_i19n_("Selected text"),
	_i19n_("URL highlight (foreground only)")
};

