// =============================================================================
//
//      --- kvi_options_dcc_general.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsDccGeneral"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_boolselector.h"
#include "kvi_fileutils.h"
#include "kvi_integerselector.h"
#include "kvi_ipselector.h"
#include "kvi_label.h"
#include "kvi_lineedit.h"
#include "kvi_locale.h"
#include "kvi_options_dcc_general.h"
#include "kvi_options.h"
#include "kvi_pushbutton.h"

/*
	@quickhelp: KviOptionsDccGeneral
	@widget: DCC general options
		Here you can set the general options for all the DCC transfers.<br>
		You can choose to ignore all the incoming DCC request or
		to notify all the requests in the console.<br>
		The outgoing DCC requests may be forced to be bound to a specific
		network interface: you may specify its IP address.<br>
		The outgoing dcc
*/
KviOptionsDccGeneral::KviOptionsDccGeneral(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_DCCGENERAL)
{
	QGridLayout *g = new QGridLayout(
		this, 14, 2, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviBoolSelector *b1 = new KviBoolSelector(this,
		__tr("Ignore all DCC requests"), &(g_pOptions->m_bIgnoreDccRequests)
	);
	g->addMultiCellWidget(b1, 0, 0, 0, 1);

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f, 1, 1, 0, 1);

	KviBoolSelector *b = new KviBoolSelector(this,
		__tr("Notify all requests in console"),
		&(g_pOptions->m_bNotifyAllDccRequestsInConsole)
	);
	g->addMultiCellWidget(b, 2, 2, 0, 1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f, 3, 3, 0, 1);

	KviLabel *l = new KviLabel(_CHAR_2_QSTRING(__tr("Save incoming files to the following directory:")), this);
	g->addMultiCellWidget(l, 4, 4, 0, 1);

	m_pIncomingDirEdit = new KviLineEdit(this);
	m_pIncomingDirEdit->setText(g_pOptions->m_szLocalIncomingDirectory.ptr());
	g->addWidget(m_pIncomingDirEdit, 5, 0);
	KviPushButton *pb = new KviPushButton(__tr("&Browse..."), this);
	connect(pb, SIGNAL(clicked()), this, SLOT(chooseIncomingDir()));
	g->addWidget(pb, 5, 1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f, 6, 6, 0, 1);

	b1 = new KviBoolSelector(this,
		__tr("Use the following local IP address for outgoing DCC requests"),
		&(g_pOptions->m_bUseUserDefinedIpForDccRequests)
	);
	g->addMultiCellWidget(b1, 7, 7, 0, 1);

	KviIpSelector *i = new KviIpSelector(this,
		__tr("Local IP address to force: "),
		&(g_pOptions->m_szDccLocalIpAddress), g_pOptions->m_bUseUserDefinedIpForDccRequests
	);
	connect(b1, SIGNAL(toggled(bool)), i, SLOT(setEnabled(bool)));
	g->addMultiCellWidget(i, 8, 8, 0, 1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addMultiCellWidget(f, 9, 9, 0, 1);

	b = new KviBoolSelector(this,
		__tr("Use the following range of ports for send requests"), &(g_pOptions->m_bDccListenOnPortsInRange)
	);
	g->addMultiCellWidget(b, 10, 10, 0, 1);

	KviIntegerSelector *ins = new KviIntegerSelector(this,
		__tr("Minimum (1-65535):"),
		&(g_pOptions->m_uMinDccListenPort), KviIntegerSelector::UShort, 1, 65535, 1025,
		g_pOptions->m_bDccListenOnPortsInRange
	);
	g->addMultiCellWidget(ins, 11, 11, 0, 1);
	connect(b, SIGNAL(toggled(bool)), ins, SLOT(setEnabled(bool)));

	ins = new KviIntegerSelector(this,
		__tr("Maximum (1-65535):"),
		&(g_pOptions->m_uMaxDccListenPort), KviIntegerSelector::UShort, 1, 65535, 65000,
		g_pOptions->m_bDccListenOnPortsInRange
	);
	g->addMultiCellWidget(ins, 12, 12, 0, 1);
	connect(b, SIGNAL(toggled(bool)), ins, SLOT(setEnabled(bool)));

	// Trick
	f = new QFrame(this);
	g->addMultiCellWidget(f, 13, 13, 0, 1);
	g->setRowStretch(13, 1);
}

KviOptionsDccGeneral::~KviOptionsDccGeneral()
{
	// Nothing here
}

void KviOptionsDccGeneral::chooseIncomingDir()
{
	KviStr szPath;
	g_pApp->getLocalKVIrcDirectory(szPath, KviApp::None);
	KviStr tmp = kvi_askForDirectoryName(szPath.ptr());
	if( tmp.hasData() )
		m_pIncomingDirEdit->setText(tmp.ptr());
}

void KviOptionsDccGeneral::commitChanges()
{
	KviBoolSelector::commitAll(this);
	commitIpSelectors();
	KviIntegerSelector::commitAll(this);
	g_pOptions->m_szLocalIncomingDirectory = m_pIncomingDirEdit->text();
}

#include "m_kvi_options_dcc_general.moc"
