// =============================================================================
//
//      --- kvi_options_dcc_send.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsDccSend"

#include <qlayout.h>

#include "kvi_boolselector.h"
#include "kvi_defines.h"
#include "kvi_integerselector.h"
#include "kvi_locale.h"
#include "kvi_options_dcc_send.h"
#include "kvi_options.h"

/*
	@quickhelp: KviOptionsDccSend
	@widget: DCC send options
		Here you can set the options for the DCC send connections.<br>
		You can choose to make KVIrc automatically accept all the incoming DCC Chat
		connections (otherwise you will be asked for the permission and a directory).<br>
		For the autoaccepted DCC sends KVIrc will choose automatically a destination
		directory (the save path of the <a href="doc_mimetypes.kvihelp">mimetype</a> of the incoming file
		or the default DCC save directory that is the $LocalKVIrcDir/incoming).<br>
		KVIrc is able to resume interrupted DCC send connections.<br>
		If you choose to autoaccept the DCC sends, the file transfers will be NEVER resumed:
		the new files will be always autorenamed and saved to the usual directory.<br>
		Some users with IP masquerading may choose to ignore the port number in the incoming
		resume requests : the explaination is quite complex so if resume does not work for you
		and you have an ip-masq'ed machine, just try this.<br>
		You can choose to use the fast-send method (also known as "send-ahead"):
		usually it is a good choice, it will make your transfers faster.<br>
		For the packet size 512 is usually a good choice.<br>
		Some minor options can be also set:<br>
		- notification of the successful transfers to the console.<br>
		- auto close of the DCC send window after a successful transfer.<br>
		- replacement of spaces with underscores in filenames (may help some clients in processing the
		dcc requests).<br>
		Please note that if you have disabled all the incoming DCC requests
		the DCC send will NOT WORK.<br>
		The "Send zero ack in DCC get sessions" is an option for some broken
		IRC clients that need a 0 bytes acknowledge to start sending the file.<br>
		If you see that all your DCC get sessions stall without receiving data,
		you may try this option.<br>
*/
KviOptionsDccSend::KviOptionsDccSend(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_DCCSEND)
{
	QGridLayout *g = new QGridLayout(
		this, 11, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviBoolSelector *b = new KviBoolSelector(this,
		__tr("Automatically accept"), &(g_pOptions->m_bAutoAcceptDccSend)
	);
	g->addWidget(b, 0, 0);

	b = new KviBoolSelector(this, __tr("Enable resume on auto-accept"), &(g_pOptions->m_bEnableResumeOnAutoAccept));
	g->addWidget(b, 1, 0);

	b = new KviBoolSelector(this, __tr("Create iconified"), &(g_pOptions->m_bCreateIconifiedDccSend));
	g->addWidget(b, 2, 0);

	b = new KviBoolSelector(this, __tr("Automatically close on success"), &(g_pOptions->m_bAutoCloseDccSendOnSuccess));
	g->addWidget(b, 3, 0);

	b = new KviBoolSelector(this,
		__tr("Notify completion in console"), &(g_pOptions->m_bNotifyDccSendCompletionInConsole)
	);
	g->addWidget(b, 4, 0);

	b = new KviBoolSelector(this,
		__tr("Replace spaces with underscores in filenames"), &(g_pOptions->m_bReplaceSpacesInDccSendFileNames)
	);
	g->addWidget(b, 5, 0);

	b = new KviBoolSelector(this,
		__tr("Ignore port number in resume requests"), &(g_pOptions->m_bIgnorePortNumberInResumeRequests)
	);
	g->addWidget(b, 6, 0);

	b = new KviBoolSelector(this,
		__tr("Send zero ack in DCC get sessions (for broken clients)"), &(g_pOptions->m_bDccGetSendZeroAck)
	);
	g->addWidget(b, 7, 0);

	b = new KviBoolSelector(this, __tr("Use fast send (a.k.a. send ahead)"), &(g_pOptions->m_bUseFastDccSend));
	g->addWidget(b, 8, 0);

	KviIntegerSelector *i = new KviIntegerSelector(this,
		__tr("Packet size (1-4096 bytes):"),
		&(g_pOptions->m_iDccSendBlockSize), KviIntegerSelector::Int, 1, KVI_DCC_SEND_MAX_BLOCK_SIZE, 512
	);
	g->addWidget(i, 9, 0);

	// Trick
	QFrame *f = new QFrame(this);
	g->addWidget(f, 10, 0);
	g->setRowStretch(10, 1);
}

KviOptionsDccSend::~KviOptionsDccSend()
{
	// Nothing here
}

void KviOptionsDccSend::commitChanges()
{
	KviBoolSelector::commitAll(this);
	KviIntegerSelector::commitAll(this);
}

#include "m_kvi_options_dcc_send.moc"
