// =============================================================================
//
//      --- kvi_options_gui_input.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsGuiInput"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_colorselector.h"
#include "kvi_fontselector.h"
#include "kvi_imageselector.h"
#include "kvi_locale.h"
#include "kvi_options_gui_input.h"
#include "kvi_options.h"

/*
	@quickhelp: KviOptionsGuiInput
	@widget: Input GUI options
*/
KviOptionsGuiInput::KviOptionsGuiInput(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIINPUT)
{
	QGridLayout *g = new QGridLayout(this, 9, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, 1);

	KviColorSelector *s = new KviColorSelector(this, __tr("Background color:"), &(g_pOptions->m_clrInputBack));
	g->addWidget(s, 0, 0);
	s = new KviColorSelector(this, __tr("Foreground color:"), &(g_pOptions->m_clrInputFore));
	g->addWidget(s, 1, 0);
	s = new KviColorSelector(this, __tr("Selection background color:"), &(g_pOptions->m_clrInputSeleBack));
	g->addWidget(s, 2, 0);
	s = new KviColorSelector(this, __tr("Selection foreground color:"), &(g_pOptions->m_clrInputSeleFore));
	g->addWidget(s, 3, 0);
	s = new KviColorSelector(this, __tr("Cursor and control marks color:"), &(g_pOptions->m_clrInputCursor));
	g->addWidget(s, 4, 0);
	KviFontSelector *f = new KviFontSelector(this, __tr("Font:"), &(g_pOptions->m_fntInput));
	g->addWidget(f, 5, 0);

	QFrame *fr = new QFrame(this);
	fr->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(fr, 6, 0);

	m_pInputImageSelector = new KviImageSelector(this,
		__tr("Use background image:"), &(g_pOptions->m_szInputBack), g_pOptions->m_pixInputBack
	);
	g->addWidget(m_pInputImageSelector, 7, 0);

	fr = new QFrame(this);
	g->addWidget(fr, 8, 0);
	g->setRowStretch(8, 1);
}

KviOptionsGuiInput::~KviOptionsGuiInput()
{
	// Nothing here
}

void KviOptionsGuiInput::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	commitImageSelectors();
	g_pOptions->loadInputBackgroundImage(m_pInputImageSelector->getImage());
	g_pOptions->calculateInputFontVariables();
	g_pApp->triggerGlobalRepaint();
}

#include "m_kvi_options_gui_input.moc"
