// =============================================================================
//
//      --- kvi_options_gui_mdi.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsGuiMdi"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_boolselector.h"
#include "kvi_colorselector.h"
#include "kvi_fontselector.h"
#include "kvi_imageselector.h"
#include "kvi_locale.h"
#include "kvi_options_gui_mdi.h"
#include "kvi_options.h"

/*
	@quickhelp: KviOptionsGuiMdi
	@widget: Mdi manager GUI options
*/
KviOptionsGuiMdi::KviOptionsGuiMdi(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMDI)
{
	QGridLayout *g = new QGridLayout(this, 12, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, 1);

	KviColorSelector *s = new KviColorSelector(
		this, __tr("Active titlebar background color:"), &(g_pOptions->m_clrMdiCaptionActiveBack)
	);
	g->addWidget(s, 0, 0);
	s = new KviColorSelector(this, __tr("Active titlebar foreground color:"), &(g_pOptions->m_clrMdiCaptionActiveFore));
	g->addWidget(s, 1, 0);
	s = new KviColorSelector(this,
		__tr("Inactive titlebar background color:"), &(g_pOptions->m_clrMdiCaptionInactiveBack)
	);
	g->addWidget(s, 2, 0);
	s = new KviColorSelector(this,
		__tr("Inactive titlebar foreground color:"), &(g_pOptions->m_clrMdiCaptionInactiveFore)
	);
	g->addWidget(s, 3, 0);

	KviFontSelector *f = new KviFontSelector(this, __tr("Titlebar font:"), &(g_pOptions->m_fntMdiCaption));
	g->addWidget(f, 4, 0);

	QFrame *fr = new QFrame(this);
	fr->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(fr, 5, 0);

	s = new KviColorSelector(this, __tr("Main window background color:"), &(g_pOptions->m_clrMdiBack));
	g->addWidget(s, 6, 0);

	m_pMdiImageSelector = new KviImageSelector(this,
		__tr("Use main window background image:"), &(g_pOptions->m_szMdiBack), g_pOptions->m_pixMdiBack
	);
	g->addWidget(m_pMdiImageSelector, 7, 0);

	fr = new QFrame(this);
	fr->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(fr, 8, 0);

	KviBoolSelector *b = new KviBoolSelector(this,
		__tr("Windows are opaque while moving"), &(g_pOptions->m_bMdiOpaqueMove)
	);
	g->addWidget(b, 9, 0);
	b = new KviBoolSelector(this, __tr("Windows are opaque while resizing"), &(g_pOptions->m_bMdiOpaqueResize));
	g->addWidget(b, 10, 0);

	fr = new QFrame(this);
	g->addWidget(fr, 11, 0);
	g->setRowStretch(11, 1);
}

KviOptionsGuiMdi::~KviOptionsGuiMdi()
{
	// Nothing here
}

void KviOptionsGuiMdi::commitChanges()
{
	KviBoolSelector::commitAll(this);
	commitColorSelectors();
	commitFontSelectors();
	commitImageSelectors();
	g_pOptions->loadMdiBackgroundImage(m_pMdiImageSelector->getImage());
	g_pApp->triggerGlobalRepaint();
}

#include "m_kvi_options_gui_mdi.moc"
