// =============================================================================
//
//      --- kvi_options_gui_messages.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsGuiMessages"

#include <qlayout.h>

#include "kvi_locale.h"
#include "kvi_messagecolorview.h"
#include "kvi_options_gui_messages.h"
#include "kvi_pushbutton.h"

KviOptionsGuiMessages::KviOptionsGuiMessages(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMESSAGES)
{
	QGridLayout *g = new QGridLayout(this, 2, 2, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, 1);

	m_pMessageColorView = new KviMessageColorView(this);
	g->addMultiCellWidget(m_pMessageColorView, 0, 0, 0, 1);

	KviPushButton *pb = new KviPushButton(__tr("&Load Colors..."), this);
	connect(pb, SIGNAL(clicked()), m_pMessageColorView, SLOT(load()));
	g->addWidget(pb, 1, 0);
	pb = new KviPushButton(__tr("&Save Colors"), this);
	connect(pb, SIGNAL(clicked()), m_pMessageColorView, SLOT(save()));
	g->addWidget(pb, 1, 1);

	g->setRowStretch(0, 1);
	installEventFilter(m_pMessageColorView);
}

KviOptionsGuiMessages::~KviOptionsGuiMessages()
{
	// Nothing here
}

void KviOptionsGuiMessages::commitChanges()
{
	m_pMessageColorView->commit();
}

#include "m_kvi_options_gui_messages.moc"
