// =============================================================================
//
//      --- kvi_options_gui_systray.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsGuiSystray"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_colorselector.h"
#include "kvi_fontselector.h"
#include "kvi_locale.h"
#include "kvi_options_gui_systray.h"
#include "kvi_options.h"

/*
	@quickhelp: KviOptionsGuiSysTray
	@widget: Systray GUI options
*/
KviOptionsGuiSysTray::KviOptionsGuiSysTray(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_GUISYSTRAY)
{
	QGridLayout *g = new QGridLayout(this, 4, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, 1);

	KviColorSelector *s = new KviColorSelector(this,
		__tr("System display background:"), &(g_pOptions->m_clrSysTrayBack)
	);
	g->addWidget(s, 0, 0);
	s = new KviColorSelector(this, __tr("System display foreground:"), &(g_pOptions->m_clrSysTrayFore));
	g->addWidget(s, 1, 0);
	KviFontSelector *f = new KviFontSelector(this,
		__tr("System display font (face only):"), &(g_pOptions->m_fntSysTray)
	);
	g->addWidget(f, 2, 0);

	QFrame *fr = new QFrame(this);
	g->addWidget(fr, 3, 0);
	g->setRowStretch(3, 1);
}

KviOptionsGuiSysTray::~KviOptionsGuiSysTray()
{
	// Nothing here
}

void KviOptionsGuiSysTray::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	g_pApp->triggerGlobalRepaint();
}

#include "m_kvi_options_gui_systray.moc"
