// =============================================================================
//
//      --- kvi_options_output.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsOutput"

#include <qlayout.h>

#include "kvi_boolselector.h"
#include "kvi_integerselector.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_options_output.h"

/*
	@quickhelp: KviOptionsOutput
	@widget: IRC output options
		Here you can finetune some of the KVIrc output.<br>
		The "Show server pings" option enables or disables displaying of the
		"Ping request from irc.myserver.com... replied" messages.<br>
		On some "pedantic" servers these messages can flood the console.<br>
		When the "Show own parts" option is enabled, when you leave a channel
		the notification of the PART is printed in the console.<br>
		This is useful when you want to "remember" which channels you have visited.<br>
		Own nickname changes are usually shown only in the channel windows.<br>
		If you want to "centralize" this output, you can ask KVIrc to print it to
		the console too.<br>
		The "Ignore MOTD" option hides the "Message of the day" sent by the servers.<br>
		The "Show extended server info" option enables analyzing of the information
		sent by the server at login time.<br>
		The server flags are analyzed and converted into nearly human readable
		feature descriptions of the current server daemon.<br>
		KVIrc usually will not show the channel WHO replies, since these are requested
		often for entire channels to acquire users data.<br>
		You can force KVIrc to show all that messages.<br>
		The same applies to the invite and exception list replies.<br>
		KVIrc features a small anti-spam algorithm.<br>
		If you enable it, KVIrc will try to scan the private messages directed
		specifically to you and that would cause a new query window to be created.<br>
		In the scan KVIrc will look for some common "spam features", and once classified
		a private message as a spam attempt, it will redirect it to the console.
		This will avoid you to be flooded by new senseless query windows that would
		just interrupt your other "serious" conversations.<br>
*/
KviOptionsOutput::KviOptionsOutput(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_OUTPUT)
{
	QGridLayout *g = new QGridLayout(
		this, 20, 2, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviBoolSelector *b = new KviBoolSelector(this,
		__tr("Show channel sync time"), &(g_pOptions->m_bShowChannelSyncTime)
	);
	g->addMultiCellWidget(b, 0, 0, 0, 1);
	b = new KviBoolSelector(this,
		__tr("Show multiple channel mode changes in single message"), &(g_pOptions->m_bSingleMessageForChannelModes)
	);
	g->addMultiCellWidget(b, 1, 1, 0, 1);
	b = new KviBoolSelector(this, __tr("Show server pings"), &(g_pOptions->m_bShowPingPong));
	g->addMultiCellWidget(b, 2, 2, 0, 1);
	b = new KviBoolSelector(this, __tr("Show own parts"), &(g_pOptions->m_bShowOwnParts));
	g->addMultiCellWidget(b, 3, 3, 0, 1);
	b = new KviBoolSelector(this, __tr("Show own nick changes in console"), &(g_pOptions->m_bShowOwnNickChanges));
	g->addMultiCellWidget(b, 4, 4, 0, 1);
	b = new KviBoolSelector(this, __tr("Ignore MOTD"), &(g_pOptions->m_bSkipMotd));
	g->addMultiCellWidget(b, 5, 5, 0, 1);
	b = new KviBoolSelector(this, __tr("Show extended server info"), &(g_pOptions->m_bShowExtendedServerInfo));
	g->addMultiCellWidget(b, 6, 6, 0, 1);
	b = new KviBoolSelector(this, __tr("Show internal who replies"), &(g_pOptions->m_bShowInternalWhoMessages));
	g->addMultiCellWidget(b, 7, 7, 0, 1);
	b = new KviBoolSelector(this,
		__tr("Show internal ban and invite exception list replies"), &(g_pOptions->m_bShowBanAndExceptionList)
	);
	g->addMultiCellWidget(b, 8, 8, 0, 1);

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f, 9, 9, 0, 1);

	b = new KviBoolSelector(this, __tr("Create query windows on remote privmsg"), &(g_pOptions->m_bCreateQueryOnPrivmsg));
	g->addMultiCellWidget(b, 10, 10, 0, 1);
	b = new KviBoolSelector(this, __tr("Create query windows on remote notice"), &(g_pOptions->m_bCreateQueryOnNotice));
	g->addMultiCellWidget(b, 11, 11, 0, 1);
	b = new KviBoolSelector(this, __tr("Create minimized query windows"), &(g_pOptions->m_bCreateIconifiedQuery));
	g->addMultiCellWidget(b, 12, 12, 0, 1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addMultiCellWidget(f, 13, 13, 0, 1);

	b = new KviBoolSelector(this,
		__tr("Filter common spam messages from new queries"), &(g_pOptions->m_bUseSmallAntispamOnPrivmsg)
	);
	g->addMultiCellWidget(b, 14, 14, 0, 1);

	KviBoolSelector *b1 = new KviBoolSelector(this,
		__tr("Enable query/clone flood protection"), &(g_pOptions->m_bUseAntiQueryFlood)
	);
	g->addMultiCellWidget(b1, 15, 15, 0, 1);
	KviIntegerSelector *i = new KviIntegerSelector(this,
		__tr("Maximum number of query windows (QUERY can override):"),
		&(g_pOptions->m_iMaxTotalQueries), KviIntegerSelector::Int, 1, 65535, 12, g_pOptions->m_bUseAntiQueryFlood
	);
	connect(b1, SIGNAL(toggled(bool)), i, SLOT(setEnabled(bool)));
	g->addMultiCellWidget(i, 16, 16, 0, 1);
	i = new KviIntegerSelector(this,
		__tr("Create maximum of:"),
		&(g_pOptions->m_iMaxQueryCount), KviIntegerSelector::Int, 1, 65535, 3, g_pOptions->m_bUseAntiQueryFlood
	);
	connect(b1, SIGNAL(toggled(bool)), i, SLOT(setEnabled(bool)));
	g->addWidget(i, 17, 0);
	i = new KviIntegerSelector(this,
		__tr(" query windows in:"),
		&(g_pOptions->m_iMaxQueryTime), KviIntegerSelector::Int, 1, 65535, 10,
		g_pOptions->m_bUseAntiQueryFlood, 100, 0, __tr(" second(s)")
	);
	connect(b1, SIGNAL(toggled(bool)), i, SLOT(setEnabled(bool)));
	g->addWidget(i, 17, 1);
	b = new KviBoolSelector(this,
		__tr("Clone flood warnings to console"),
		&(g_pOptions->m_bQueryFloodWarningsToConsole), g_pOptions->m_bUseAntiQueryFlood
	);
	connect(b1, SIGNAL(toggled(bool)), b, SLOT(setEnabled(bool)));
	g->addMultiCellWidget(b, 18, 18, 0, 1);

	// Trick
	f = new QFrame(this);
	g->addMultiCellWidget(f, 19, 19, 0, 1);
	g->setRowStretch(19, 1);
}

KviOptionsOutput::~KviOptionsOutput()
{
	// Nothing here
}

void KviOptionsOutput::commitChanges()
{
	KviBoolSelector::commitAll(this);
	KviIntegerSelector::commitAll(this);
}

#include "m_kvi_options_output.moc"
