// =============================================================================
//
//      --- kvi_options_redirections.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsRedirections"

#include <qlayout.h>

#include "kvi_boolselector.h"
#include "kvi_label.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_options_redirections.h"
#include "kvi_string.h"

/*
	@quickhelp: KviOptionsRedirections
	@widget: Output messages redirection options
		Most of the messages that KVIrc prints in the channel
		or "active" windows can be redirected to the console.<br>
		For example, if you use to join high traffic channels
		with many users joining and leaving, you may want
		to redirect QUIT, JOIN and PART messages to console
		so you will be able to follow the discussions on the channel.
*/
KviOptionsRedirections::KviOptionsRedirections(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_REDIRECTIONS)
{
	QGridLayout *g = new QGridLayout(this, 17, 2, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, 0);

	KviLabel *l = new KviLabel(_CHAR_2_QSTRING(__tr("Redirect to console the following messages:")), this);
	g->addMultiCellWidget(l, 0, 0, 0, 1);

	KviBoolSelector *b = new KviBoolSelector(this, __tr("Join messages"), &(g_pOptions->m_bJoinMsgsToConsole));
	g->addWidget(b, 1, 0);
	b = new KviBoolSelector(this, __tr("Part messages"), &(g_pOptions->m_bPartMsgsToConsole));
	g->addWidget(b, 2, 0);
	b = new KviBoolSelector(this, __tr("Kick messages"), &(g_pOptions->m_bKickMsgsToConsole));
	g->addWidget(b, 3, 0);
	b = new KviBoolSelector(this, __tr("Quit messages"), &(g_pOptions->m_bQuitMsgsToConsole));
	g->addWidget(b, 4, 0);
	b = new KviBoolSelector(this, __tr("Nick changes"), &(g_pOptions->m_bNickMsgsToConsole));
	g->addWidget(b, 5, 0);
	b = new KviBoolSelector(this, __tr("Nickname errors"), &(g_pOptions->m_bNicknameErrorsToConsole));
	g->addWidget(b, 6, 0);
	b = new KviBoolSelector(this, __tr("User mode changes"), &(g_pOptions->m_bUserModeChangesToConsole));
	g->addWidget(b, 7, 0);
	b = new KviBoolSelector(this, __tr("Channel mode changes"), &(g_pOptions->m_bChannelModeChangesToConsole));
	g->addWidget(b, 8, 0);
	b = new KviBoolSelector(this, __tr("Ban, invite and exception lists"),&(g_pOptions->m_bBanAndExceptionListToConsole));
	g->addWidget(b, 9, 0);
	b = new KviBoolSelector(this, __tr("Topic changes"), &(g_pOptions->m_bTopicMsgsToConsole));
	g->addWidget(b, 10, 0);
	b = new KviBoolSelector(this, __tr("Invite messages"), &(g_pOptions->m_bInviteMessagesToConsole));
	g->addWidget(b, 11, 0);
	b = new KviBoolSelector(this, __tr("Notices from off-channel users"), &(g_pOptions->m_bOffChannelNoticesToConsole));
	g->addWidget(b, 12, 0);
	b = new KviBoolSelector(this, __tr("Private CTCP requests"), &(g_pOptions->m_bCtcpRequestsToConsole));
	g->addWidget(b, 13, 0);
	b = new KviBoolSelector(this, __tr("Channel CTCP requests"), &(g_pOptions->m_bChannelCtcpRequestsToConsole));
	g->addWidget(b, 14, 0);
	b = new KviBoolSelector(this, __tr("CTCP replies"), &(g_pOptions->m_bCtcpRepliesToConsole));
	g->addWidget(b, 15, 0);
	b = new KviBoolSelector(this, __tr("Wallop messages"), &(g_pOptions->m_bWallopsToConsole));
	g->addWidget(b, 1, 1);
	b = new KviBoolSelector(this, __tr("Names replies"), &(g_pOptions->m_bNamesReplyToConsole));
	g->addWidget(b, 2, 1);
	b = new KviBoolSelector(this, __tr("Who replies"), &(g_pOptions->m_bWhoMsgsToConsole));
	g->addWidget(b, 3, 1);
	b = new KviBoolSelector(this, __tr("Whois replies"), &(g_pOptions->m_bWhoisRepliesToConsole));
	g->addWidget(b, 4, 1);
	b = new KviBoolSelector(this, __tr("Notify list changes"), &(g_pOptions->m_bNotifyListChangesToConsole));
	g->addWidget(b, 5, 1);
	b = new KviBoolSelector(this, __tr("Server info"), &(g_pOptions->m_bServerInfoToConsole));
	g->addWidget(b, 6, 1);
	b = new KviBoolSelector(this, __tr("Server notices"), &(g_pOptions->m_bServerNoticesToConsole));
	g->addWidget(b, 7, 1);
	b = new KviBoolSelector(this, __tr("Unhandled numerics"), &(g_pOptions->m_bUnhandledNumericsToConsole));
	g->addWidget(b, 8, 1);
	b = new KviBoolSelector(this, __tr("Unhandled literals"), &(g_pOptions->m_bUnhandledLiteralsToConsole));
	g->addWidget(b, 9, 1);
	b = new KviBoolSelector(this, __tr("Unhandled server errors"), &(g_pOptions->m_bUnhandledServerErrorsToConsole));
	g->addWidget(b, 10, 1);
	b = new KviBoolSelector(this, __tr("Local desync warnings"), &(g_pOptions->m_bDesyncMsgsToConsole));
	g->addWidget(b, 11, 1);
	b = new KviBoolSelector(this, __tr("Split warnings"), &(g_pOptions->m_bSplitWarningsToConsole));
	g->addWidget(b, 12, 1);
	b = new KviBoolSelector(this, __tr("DNS results"), &(g_pOptions->m_bDnsResultsToConsole));
	g->addWidget(b, 13, 1);
	b = new KviBoolSelector(this, __tr("Process output"), &(g_pOptions->m_bProcessOutputToConsole));
	g->addWidget(b, 14, 1);

	// Trick
	QFrame *f = new QFrame(this);
	g->addMultiCellWidget(f, 16, 16, 0, 1);
	g->setRowStretch(16, 1);
}

KviOptionsRedirections::~KviOptionsRedirections()
{
	// Nothing here
}

void KviOptionsRedirections::commitChanges()
{
	KviBoolSelector::commitAll(this);
}

#include "m_kvi_options_redirections.moc"
