// =============================================================================
//
//      --- kvi_optionsdialog.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsDialog"

#include <qvbox.h>

#include "kvi_app.h"
#include "kvi_defines.h"
#include "kvi_frame.h"
#include "kvi_iconloader.h"
#include "kvi_locale.h"
#include "kvi_maintoolbar.h"
#include "kvi_options_charset_translation.h"
#include "kvi_options_ctcp_messages.h"
#include "kvi_options_ctcp_multimedia.h"
#include "kvi_options_ctcp_protection.h"
#include "kvi_options_dcc_chat.h"
#include "kvi_options_dcc_general.h"
#include "kvi_options_dcc_send.h"
#include "kvi_options_dcc_voice.h"
#include "kvi_options_defaultmessages.h"
#include "kvi_options_dirbrowser.h"
#include "kvi_options_front.h"
#include "kvi_options_gui_global.h"
#include "kvi_options_gui_help.h"
#include "kvi_options_gui_input.h"
#include "kvi_options_gui_labels.h"
#include "kvi_options_gui_listbox.h"
#include "kvi_options_gui_mdi.h"
#include "kvi_options_gui_messages.h"
#include "kvi_options_gui_mirccolors.h"
#include "kvi_options_gui_output.h"
#include "kvi_options_gui_systray.h"
#include "kvi_options_input.h"
#include "kvi_options_interface.h"
#include "kvi_options_irc.h"
#include "kvi_options_listview.h"
#include "kvi_options_logging.h"
#include "kvi_options_mimetypes.h"
#include "kvi_options_output.h"
#include "kvi_options_plugins.h"
#include "kvi_options_redirections.h"
#include "kvi_options_scriptcenter.h"
#include "kvi_options_view.h"
#include "kvi_options.h"
#include "kvi_optionsdialog.h"
#include "kvi_settings.h"
#include "kvi_string.h"

// Declared in kvi_app.cpp and managed by KviApp class
extern QPixmap *g_pixViewOut[KVI_OUT_NUM_IMAGES];

/*
	@quickhelp: KviOptionsDialog
	@widget: General options dialog
		Here you can set your preferences.<br>
		By selecting a category from the left list view you will
		access the related options.<br>
		By clicking Ok you accept the changes, by clicking Cancel you reject it :)<br>
*/
KviOptionsDialog::KviOptionsDialog(QWidget *parent)
	: KviTreeListDialog(parent, "options_dialog", false, __tr("KVIrc: General Options"))
{
	QStringList path, root, root0;
	m_pageIndex.setAutoDelete(true);
	setIcon(KviIconLoader::loadIcon(tb_configGeneral));

	root0 = QStringList(__tr("Appearance"));
	addPage(root0, KVI_OUT_COLORS, KVI_GENERAL_OPTIONS_WIDGET_ID_NONE);
		root = QStringList(root0);
		root.append(__tr("Fonts & Colors"));
		addPage(root, KVI_OUT_WIDGET, KVI_GENERAL_OPTIONS_WIDGET_ID_NONE);
			path = QStringList(root);
			path.append(__tr("Application"));
			addPage(path, KVI_OUT_QUIT, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIGLOBAL);
			path = QStringList(root);
			path.append(__tr("Channel Labels"));
			addPage(path, KVI_OUT_TOPIC, KVI_GENERAL_OPTIONS_WIDGET_ID_GUILABELS);
			path = QStringList(root);
			path.append(__tr("Channel Userlist"));
			addPage(path, KVI_OUT_WHO, KVI_GENERAL_OPTIONS_WIDGET_ID_GUILISTBOX);
			path = QStringList(root);
			path.append(__tr("Help Browser"));
			addPage(path, KVI_OUT_HELP, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIHELP);
			path = QStringList(root);
			path.append(__tr("Input Text"));
			addPage(path, KVI_OUT_INPUT, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIINPUT);
			path = QStringList(root);
			path.append(__tr("MDI Windows"));
			addPage(path, KVI_OUT_NONE, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMDI);
			path = QStringList(root);
			path.append(__tr("Output Text"));
			addPage(path, KVI_OUT_RAW, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIOUTPUT);
			path = QStringList(root);
			path.append(__tr("System Tray"));
			addPage(path, KVI_OUT_TIME, KVI_GENERAL_OPTIONS_WIDGET_ID_GUISYSTRAY);
		root = QStringList(root0);
		root.append(__tr("Messages"));
		addPage(root, KVI_OUT_RAW, KVI_GENERAL_OPTIONS_WIDGET_ID_NONE);
			path = QStringList(root);
			path.append(__tr("Message Colors"));
			addPage(path, KVI_OUT_PRIVMSG, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMESSAGES);
			path = QStringList(root);
			path.append(__tr("mIRC & KSirc"));
			addPage(path, KVI_OUT_MIRC, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMIRCCOLORS);

	root = QStringList(__tr("CTCP"));
	addPage(root, KVI_OUT_CTCPREQUEST, KVI_GENERAL_OPTIONS_WIDGET_ID_NONE);
		path = QStringList(root);
		path.append(__tr("Flood Protection"));
		addPage(path, KVI_OUT_CTCPERROR, KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPPROTECTION);
		path = QStringList(root);
		path.append(__tr("Multimedia"));
		addPage(path, KVI_OUT_MULTIMEDIA, KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMULTIMEDIA);
		path = QStringList(root);
		path.append(__tr("Reply Messages"));
		addPage(path, KVI_OUT_CTCPREPLY, KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMESSAGES);

	root = QStringList(__tr("DCC"));
	addPage(root, KVI_OUT_DCCINFO, KVI_GENERAL_OPTIONS_WIDGET_ID_NONE);
		path = QStringList(root);
		path.append(__tr("Chat"));
		addPage(path, KVI_OUT_DCCERROR, KVI_GENERAL_OPTIONS_WIDGET_ID_DCCCHAT);
		path = QStringList(root);
		path.append(__tr("General"));
		addPage(path, KVI_OUT_DCCWARNING, KVI_GENERAL_OPTIONS_WIDGET_ID_DCCGENERAL);
		path = QStringList(root);
		path.append(__tr("Send"));
		addPage(path, KVI_OUT_PACKET, KVI_GENERAL_OPTIONS_WIDGET_ID_DCCSEND);
		path = QStringList(root);
		path.append(__tr("Voice"));
		addPage(path, KVI_OUT_TALK, KVI_GENERAL_OPTIONS_WIDGET_ID_DCCVOICE);

	root = QStringList(__tr("Interface"));
	addPage(root, KVI_OUT_KVIRC, KVI_GENERAL_OPTIONS_WIDGET_ID_NONE);
		path = QStringList(root);
		path.append(__tr("Directory Browser"));
		addPage(path, KVI_OUT_DIR, KVI_GENERAL_OPTIONS_WIDGET_ID_DIRBROWSER);
		path = QStringList(root);
		path.append(__tr("Input Widget"));
		addPage(path, KVI_OUT_INPUT, KVI_GENERAL_OPTIONS_WIDGET_ID_INPUT);
		path = QStringList(root);
		path.append(__tr("Miscellaneous"));
		addPage(path, KVI_OUT_ECHO, KVI_GENERAL_OPTIONS_WIDGET_ID_INTERFACEMISC);
		path = QStringList(root);
		path.append(__tr("Output Widget"));
		addPage(path, KVI_OUT_RAW, KVI_GENERAL_OPTIONS_WIDGET_ID_VIEW);
		path = QStringList(root);
		path.append(__tr("Script Center"));
		addPage(path, KVI_OUT_SCRIPT, KVI_GENERAL_OPTIONS_WIDGET_ID_SCRIPTCENTER);

	root = QStringList(__tr("IRC Engine"));
	addPage(root, KVI_OUT_SOCKET, KVI_GENERAL_OPTIONS_WIDGET_ID_NONE);
		path = QStringList(root);
		path.append(__tr("Console Messages"));
		addPage(path, KVI_OUT_PART, KVI_GENERAL_OPTIONS_WIDGET_ID_REDIRECTIONS);
		path = QStringList(root);
		path.append(__tr("Default Messages"));
		addPage(path, KVI_OUT_MOTD, KVI_GENERAL_OPTIONS_WIDGET_ID_DEFAULTMESSAGES);
		path = QStringList(root);
		path.append(__tr("Logging"));
		addPage(path, KVI_OUT_LOG, KVI_GENERAL_OPTIONS_WIDGET_ID_LOGGING);
		path = QStringList(root);
		path.append(__tr("Miscellaneous"));
		addPage(path, KVI_OUT_OP, KVI_GENERAL_OPTIONS_WIDGET_ID_IRCMISC);
		path = QStringList(root);
		path.append(__tr("Output"));
		addPage(path, KVI_OUT_PRIVMSG, KVI_GENERAL_OPTIONS_WIDGET_ID_OUTPUT);

	root = QStringList(__tr("Miscellaneous"));
	addPage(root, KVI_OUT_IDEA, KVI_GENERAL_OPTIONS_WIDGET_ID_NONE);
#ifdef COMPILE_NEED_CHARSET_TRANSLATION
		path = QStringList(root);
		path.append(__tr("Charset Translation"));
		addPage(path, KVI_OUT_ECHO, KVI_GENERAL_OPTIONS_WIDGET_ID_CHARSETTRANSLATION);
#endif
		path = QStringList(root);
		path.append(__tr("MIME Types"));
		addPage(path, KVI_OUT_FILE, KVI_GENERAL_OPTIONS_WIDGET_ID_MIMETYPES);
#ifdef COMPILE_PLUGIN_SUPPORT
		path = QStringList(root);
		path.append(__tr("Plugins"));
		addPage(path, KVI_OUT_PLUGIN, KVI_GENERAL_OPTIONS_WIDGET_ID_PLUGINS);
#endif

	setButtonHelpText(__tr("What is &This?"));
	setGeometry(g_pOptions->m_rectGeneralOptionsDialog);
	connect(this, SIGNAL(aboutToShowPage(QWidget *)), this, SLOT(slotAboutToShowPage(QWidget *)));
	connect(this, SIGNAL(cancelClicked()), this, SLOT(cancelClicked()));
	connect(this, SIGNAL(helpClicked()), g_pApp, SLOT(slot_whatIsThisRequest()));
	connect(this, SIGNAL(okClicked()), this, SLOT(okClicked()));
}

KviOptionsDialog::~KviOptionsDialog()
{
	QPtrDictIterator<OptionsPage> iter(m_pageIndex);
	for( ; iter.current(); ++iter ) {
		OptionsPage *p = iter.current();
		if( p->widget ) {
			delete p->widget;
			p->widget = 0;
		}
	}
}

void KviOptionsDialog::addPage(QStringList path, int icon_type, int config_type)
{
	QString header = path.join(" >> ");
	QVBox *w = KviTreeListDialog::addVBoxPage(path, header, *g_pixViewOut[icon_type]);
	OptionsPage *p = new OptionsPage();
	p->type   = config_type;
	p->widget = 0;
	if( config_type == KVI_GENERAL_OPTIONS_WIDGET_ID_NONE )
		p->widget = new KviOptionsFront(w);
	m_pageIndex.insert(w, p);
}

void KviOptionsDialog::cancelClicked()
{
	emit KviTreeListDialog::finished();
}

void KviOptionsDialog::okClicked()
{
	if( g_pOptions->m_bUseHackedFrameGeometry ) {
		g_pOptions->m_rectGeneralOptionsDialog.moveTopLeft(frameGeometry().topLeft());
		g_pOptions->m_rectGeneralOptionsDialog.setSize(size());
	} else g_pOptions->m_rectGeneralOptionsDialog = geometry();

	// Commit changes for all the active modules
	QPtrDictIterator<OptionsPage> iter(m_pageIndex);
	for( ; iter.current(); ++iter ) {
		OptionsPage *p = iter.current();
		if( p->widget )
			p->widget->commitChanges();
	}

	for( KviFrame *f = g_pApp->m_pFrameList->first(); f; f = g_pApp->m_pFrameList->next() )
		f->restartIdleTimer(); // Always do this
	emit KviTreeListDialog::finished();
}

void KviOptionsDialog::slotAboutToShowPage(QWidget *page)
{
	OptionsPage *p = m_pageIndex.find(page);
	if( !p ) return;

	if( p->widget ) return; // Widget was already created

	switch( p->type ) {
		case KVI_GENERAL_OPTIONS_WIDGET_ID_DEFAULTMESSAGES:
			p->widget = new KviOptionsDefaultMessages(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMESSAGES:
			p->widget = new KviOptionsCtcpMessages(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_REDIRECTIONS:
			p->widget = new KviOptionsRedirections(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPPROTECTION:
			p->widget = new KviOptionsCtcpProtection(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMULTIMEDIA:
			p->widget = new KviOptionsCtcpMultimedia(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_VIEW:
			p->widget = new KviOptionsView(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_INPUT:
			p->widget = new KviOptionsInput(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_LOGGING:
			p->widget = new KviOptionsLogging(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_DIRBROWSER:
			p->widget = new KviOptionsDirBrowser(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_OUTPUT:
			p->widget = new KviOptionsOutput(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_MIMETYPES:
			p->widget = new KviOptionsMimeTypes(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_IRCMISC:
			p->widget = new KviOptionsIrc(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_INTERFACEMISC:
			p->widget = new KviOptionsInterface(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_DCCGENERAL:
			p->widget = new KviOptionsDccGeneral(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_DCCCHAT:
			p->widget = new KviOptionsDccChat(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_DCCSEND:
			p->widget = new KviOptionsDccSend(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_DCCVOICE:
			p->widget = new KviOptionsDccVoice(page);
			break;
#ifdef COMPILE_PLUGIN_SUPPORT
		case KVI_GENERAL_OPTIONS_WIDGET_ID_PLUGINS:
			p->widget = new KviOptionsPlugins(page);
			break;
#endif
		case KVI_GENERAL_OPTIONS_WIDGET_ID_SCRIPTCENTER:
			p->widget = new KviOptionsScriptCenter(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMDI:
			p->widget = new KviOptionsGuiMdi(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIINPUT:
			p->widget = new KviOptionsGuiInput(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_GUILABELS:
			p->widget = new KviOptionsGuiLabels(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIHELP:
			p->widget = new KviOptionsGuiHelp(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_GUILISTBOX:
			p->widget = new KviOptionsGuiListBox(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIOUTPUT:
			p->widget = new KviOptionsGuiOutput(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMIRCCOLORS:
			p->widget = new KviOptionsGuiMircColors(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMESSAGES:
			p->widget = new KviOptionsGuiMessages(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_GUISYSTRAY:
			p->widget = new KviOptionsGuiSysTray(page);
			break;
		case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIGLOBAL:
			p->widget = new KviOptionsGuiGlobal(page);
			break;
#ifdef COMPILE_NEED_CHARSET_TRANSLATION
		case KVI_GENERAL_OPTIONS_WIDGET_ID_CHARSETTRANSLATION:
			p->widget = new KviOptionsCharsetTranslation(page);
			break;
#endif
		default:
			p->widget = new KviOptionsFront(page);
			break;
	}
}

#include "m_kvi_optionsdialog.moc"
