// =============================================================================
//
//      --- kvi_script_center.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviScriptCenter"

#include <qgrid.h>

#include "kvi_aliaseditor.h"
#include "kvi_app.h"
#include "kvi_codetester.h"
#include "kvi_eventeditor.h"
#include "kvi_frame.h"
#include "kvi_helpwindow.h"
#include "kvi_iconloader.h"
#include "kvi_locale.h"
#include "kvi_maintoolbar.h"
#include "kvi_objectviewer.h"
#include "kvi_options.h"
#include "kvi_popupeditor.h"
#include "kvi_pushbutton.h"
#include "kvi_raweventeditor.h"
#include "kvi_script_center.h"
#include "kvi_usertoolbareditor.h"
#include "kvi_usertoolbar.h"
#include "kvi_variableseditor.h"

// TODO: Totally missing quick help!

int g_iLastScriptDialogTab = -1;

/*
	@quickhelp: KviScriptCenter
	@widget: Script Center
		This dialog allows you to edit KVI++ script elements.<br>
		Do not be scared by the number of the tabs in this dialog;
		once you understand the meaning of each tab, you will find this dialog very useful.<br>
		Have fun exploring the Script Center!<br>
		<a href="qh_kvialiaseditor.kvihelp">Alias editor</a><br>
		<a href="qh_kvieventeditor.kvihelp">Event editor</a><br>
		<a href="qh_kviraweventeditor.kvihelp">Raw event editor</a><br>
		<a href="qh_kvipopupeditor.kvihelp">Popup editor</a><br>
		<a href="qh_kviutoolbareditor.kvihelp">Toolbar editor</a><br>
		<a href="qh_kvivariableseditor.kvihelp">Variables editor</a><br>
		<a href="qh_kviobjectviewer.kvihelp">Object viewer</a><br>
		<a href="qh_kvicodetester.kvihelp">Code tester</a><br>
*/

/**
 *
 * SCRIPT CENTER
 *
 */
KviScriptCenter::KviScriptCenter(QWidget *parent)
	: KviTabDialog(parent, "script_center", false, __tr("KVIrc: Script Center"), Ok | Apply | Help | Cancel)
{
	QGrid *page;
	setIcon(KviIconLoader::loadIcon(tb_scriptCenter));

	page = addGridPage(1, Qt::Vertical, _CHAR_2_QSTRING(__tr("&Aliases")));
	m_pAliasEditor = new KviAliasEditor(page, "script_tab_aliases");

	page = addGridPage(1, Qt::Vertical, _CHAR_2_QSTRING(__tr("&Events")));
	m_pHiLevelEventEditor = new KviEventEditor(page, "script_tab_events");

	page = addGridPage(1, Qt::Vertical, _CHAR_2_QSTRING(__tr("&Raw Events")));
	m_pRawEventEditor = new KviRawEventEditor(page, "script_tab_rawevents");

	page = addGridPage(1, Qt::Vertical, _CHAR_2_QSTRING(__tr("&Popups")));
	m_pThePopupEditor = new KviPopupEditor(page, "script_tab_popups");

	page = addGridPage(1, Qt::Vertical, _CHAR_2_QSTRING(__tr("&User Toolbar")));
	m_pUserToolBarEditor = new KviUserToolBarEditor(page, "script_tab_utoolbar");

	page = addGridPage(1, Qt::Vertical, _CHAR_2_QSTRING(__tr("&Variables")));
	m_pVariablesEditor = new KviVariablesEditor(page, "script_tab_variables");

	page = addGridPage(1, Qt::Vertical, _CHAR_2_QSTRING(__tr("&Objects")));
	m_pObjectViewer = new KviObjectViewer(page, "script_tab_objectviewer");

	page = addGridPage(1, Qt::Vertical, _CHAR_2_QSTRING(__tr("&Tester")));
	m_pCodeTester = new KviCodeTester(page, "script_tab_codetester");

	if( g_pOptions->m_bScriptCenterAddHelpBrowser ) {
		page = addGridPage(1, Qt::Vertical, _CHAR_2_QSTRING(__tr("&Help Browser")));
		m_pHelpWindow = new KviHelpWindow(g_pApp->m_pFrameList->first(), page, "script_tab_helpbrowser");
	} else m_pHelpWindow = 0;

	if( g_iLastScriptDialogTab != -1 )
		showPage(g_iLastScriptDialogTab);

	setButtonHelpText(__tr("What is &This?"));
	connect(this, SIGNAL(helpClicked()),   g_pApp, SLOT(slot_whatIsThisRequest()));
	connect(this, SIGNAL(okClicked()),     this,   SLOT(acceptClicked()));
	connect(this, SIGNAL(applyClicked()),  this,   SLOT(applyClicked()));
	connect(this, SIGNAL(cancelClicked()), this,   SLOT(rejectClicked()));

	setGeometry(g_pOptions->m_rectScriptDialog);
}

KviScriptCenter::~KviScriptCenter()
{
	emit closed();
}

void KviScriptCenter::applyClicked()
{
	if( g_pOptions->m_bUseHackedFrameGeometry ) {
		g_pOptions->m_rectScriptDialog.moveTopLeft(frameGeometry().topLeft());
		g_pOptions->m_rectScriptDialog.setSize(size());
	} else g_pOptions->m_rectScriptDialog = geometry();

	m_pAliasEditor->commit();
	m_pRawEventEditor->commit();
	m_pHiLevelEventEditor->commit();
	m_pThePopupEditor->commit();
	m_pUserToolBarEditor->commit();
	m_pVariablesEditor->commit();
	m_pVariablesEditor->fillVariablesEditor();
	m_pObjectViewer->fillViews();
	for( KviFrame *f = g_pApp->m_pFrameList->first(); f; f = g_pApp->m_pFrameList->next() ) {
		f->updateUserToolBar();
	}
}

void KviScriptCenter::acceptClicked()
{
	if( g_pOptions->m_bUseHackedFrameGeometry ) {
		g_pOptions->m_rectScriptDialog.moveTopLeft(frameGeometry().topLeft());
		g_pOptions->m_rectScriptDialog.setSize(size());
	} else g_pOptions->m_rectScriptDialog = geometry();

	if( activePageIndex() != -1 )
		g_iLastScriptDialogTab = activePageIndex();

	m_pAliasEditor->commit();
	m_pRawEventEditor->commit();
	m_pHiLevelEventEditor->commit();
	m_pThePopupEditor->commit();
	m_pUserToolBarEditor->commit();
	m_pVariablesEditor->commit();

	for( KviFrame *f = g_pApp->m_pFrameList->first(); f; f = g_pApp->m_pFrameList->next() ) {
		f->updateUserToolBar();
	}

	if( g_pOptions->m_bScriptCenterAutoSaveWhenAccepted )
	{
		g_pOptions->saveEvents();
		g_pOptions->saveRawEvents();
		g_pOptions->savePopups();
		g_pOptions->saveAliases();
		g_pOptions->saveToolBar();
	}

	delayedDestruct();
}

#ifndef COMPILE_WITH_KDE
void KviScriptCenter::keyPressEvent(QKeyEvent *e)
{
	if( e->key() == Qt::Key_Escape ) {
		e->accept();
		delayedDestruct();
	} else e->ignore();
}
#endif

void KviScriptCenter::rejectClicked()
{
	delayedDestruct();
}

void KviScriptCenter::closeEvent(QCloseEvent *e)
{
	e->accept();
	delayedDestruct();
}

#include "m_kvi_script_center.moc"
