// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviScriptTabWidget"

#include <qtabwidget.h>

#include "kvi_error.h"
#include "kvi_locale.h"
#include "kvi_script_objectclassdefinition.h"
#include "kvi_script_objectcontroller.h"
#include "kvi_script_tabwidget.h"

/*
	@class: tabwidget
	@short:
		A stack of tabbed widgets
	@inherits:
		[class]object[/class]<br>
		[class]widget[/class]
	@functions:
		!fn: $addTab(<widget_object>, <label>)
		!fn: $removeTab(<widget_object>)
		!fn: $showTab>(<widget_object>)
	@description:

	@examples:

	@seealso:
		class [class]object[/class], <br>
		class [class]widget[/class], <br>
		<a href="syntax_objects.kvihelp">Objects documentation</a><br>
*/

/**
 * TABWIDGET class
 */
void KviScriptTabWidget::initializeClassDefinition(KviScriptObjectClassDefinition *d)
{
	d->addBuiltinFunction("addTab",    (scriptObjectFunction) &KviScriptTabWidget::builtinFunction_ADDTAB);
	d->addBuiltinFunction("removeTab", (scriptObjectFunction) &KviScriptTabWidget::builtinFunction_REMOVETAB);
	d->addBuiltinFunction("showTab",   (scriptObjectFunction) &KviScriptTabWidget::builtinFunction_SHOWTAB);
}

KviScriptTabWidget::KviScriptTabWidget(
	KviScriptObjectController *cntrl, KviScriptObject *p, const char *name, KviScriptObjectClassDefinition *pDef)
	: KviScriptWidget(cntrl, p, name, pDef)
{
	// Nothing here
}

KviScriptTabWidget::~KviScriptTabWidget()
{
	// Nothing here
}

bool KviScriptTabWidget::init(QPtrList<KviStr> *params)
{
	if( parent() ) {
		if( parent()->inherits("KviScriptWidget") ) {
			m_pWidget = new QTabWidget(((KviScriptWidget *) parent())->m_pWidget, name());
		}
	}

	if( !m_pWidget )
		m_pWidget = new QTabWidget(0, name());
	m_bAutoDestroyControlledWidget = true;
	m_pWidget->installEventFilter(this);
	connect(m_pWidget, SIGNAL(destroyed()), this, SLOT(widgetDestroyed()));
	return true;
}

int KviScriptTabWidget::builtinFunction_ADDTAB(QPtrList<KviStr> *params, KviStr &buffer)
{
	if( params ) {
		KviStr *pS = params->first();
		if( pS ) {
			KviScriptObject *o = controller()->findObjectById(pS->ptr());
			if( o ) {
				if( o->inherits("KviScriptWidget") ) {
					KviStr *pS2 = params->next();
					((QTabWidget *) m_pWidget)->addTab(
						((KviScriptWidget *) o)->m_pWidget, pS2 ? pS2->ptr() : __tr("unnamed")
					);
				} else return KVI_ERROR_ObjectIsNotAWidget;
			} else return KVI_ERROR_ObjectNotFound;
		} else return KVI_ERROR_MissingObjectId;
	} else return KVI_ERROR_MissingParameter;
	return KVI_ERROR_Success;
}

int KviScriptTabWidget::builtinFunction_REMOVETAB(QPtrList<KviStr> *params, KviStr &buffer)
{
	if( params ) {
		KviStr *pS = params->first();
		if( pS ) {
			KviScriptObject *o = controller()->findObjectById(pS->ptr());
			if( o ) {
				if( o->inherits("KviScriptWidget") ) {
					((QTabWidget *) m_pWidget)->removePage(((KviScriptWidget *) o)->m_pWidget);
				} else return KVI_ERROR_ObjectIsNotAWidget;
			} else return KVI_ERROR_ObjectNotFound;
		} else return KVI_ERROR_MissingObjectId;
	} else return KVI_ERROR_MissingParameter;
	return KVI_ERROR_Success;
}

int KviScriptTabWidget::builtinFunction_SHOWTAB(QPtrList<KviStr> *params, KviStr &buffer)
{
	if( params ) {
		KviStr *pS = params->first();
		if( pS ) {
			KviScriptObject *o = controller()->findObjectById(pS->ptr());
			if( o ) {
				if( o->inherits("KviScriptWidget") ) {
					((QTabWidget *) m_pWidget)->showPage(((KviScriptWidget *) o)->m_pWidget);
				} else return KVI_ERROR_ObjectIsNotAWidget;
			} else return KVI_ERROR_ObjectNotFound;
		} else return KVI_ERROR_MissingObjectId;
	} else return KVI_ERROR_MissingParameter;
	return KVI_ERROR_Success;
}

#include "m_kvi_script_tabwidget.moc"
