// =============================================================================
//
//      --- kvi_systray_icondisplay.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviSysTrayIconDisplay"

#include <qiconset.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qtooltip.h>

#include "kvi_iconloader.h"
#include "kvi_locale.h"
#include "kvi_systray.h"
#include "kvi_systray_icondisplay.h"

KviSysTrayIconDisplay::KviSysTrayIconDisplay(KviSysTray *parent)
	: QWidget(parent, "systray_icon_display")
{
	m_pSysTray = parent;
	m_pIcon    = 0;
	setBackgroundMode(NoBackground);
	QToolTip::add(this, __tr("Change system tray display mode"));
}

KviSysTrayIconDisplay::~KviSysTrayIconDisplay()
{
	if( m_pIcon ) {
		delete m_pIcon;
		m_pIcon = 0;
	}
}

void KviSysTrayIconDisplay::setIcon(QString icon)
{
	if( m_pIcon ) {
		delete m_pIcon;
		m_pIcon = 0;
	}
	m_pIcon = new QIconSet(KviIconLoader::loadIcon(icon));
	update();
}

void KviSysTrayIconDisplay::paintEvent(QPaintEvent *)
{
	if( !isVisible() )
		return;

	QPainter pa(m_pSysTray->getMemoryBuffer());
	int widgetWidth  = width();
	int widgetHeight = height();

	pa.fillRect(0, 0, widgetWidth, widgetHeight, m_pSysTray->getBackground());

	if( m_pIcon ) {
		QPixmap pix = m_pIcon->pixmap((height() > 32) ? QIconSet::Large : QIconSet::Small, true);
		int pos = (widgetHeight - pix.height()) >> 1;
		if( pix.mask() ) {
			pa.setClipping(true);
			pa.setClipRect(pos, pos, widgetWidth, widgetHeight);
		}
		// Draw the pixmap
		bitBlt(m_pSysTray->getMemoryBuffer(), pos, pos, &pix, 0, 0, pix.width(), pix.height());
		pa.setClipping(false);
	}

	pa.setPen(QPen(colorGroup().dark(), 1));
	pa.drawLine(0, 0, widgetWidth - 1, 0);
	pa.drawLine(0, 0, 0, widgetHeight);
	pa.setPen(colorGroup().light());
	pa.drawLine(1, widgetHeight - 1, widgetWidth, widgetHeight - 1);
	pa.drawLine(widgetWidth - 1, 0, widgetWidth - 1, widgetHeight);

	bitBlt(this, 0, 0, m_pSysTray->getMemoryBuffer(), 0, 0, widgetWidth, widgetHeight);
}

void KviSysTrayIconDisplay::mousePressEvent(QMouseEvent *)
{
	m_pSysTray->rotateMode();
}

#include "m_kvi_systray_icondisplay.moc"
