// =============================================================================
//
//      --- kvi_systray_utcclock.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviSysTrayUtcClock"

#include "kvi_locale.h"
#include "kvi_systray.h"
#include "kvi_systray_utcclock.h"

KviSysTrayUtcClock::KviSysTrayUtcClock(KviSysTray *parent)
	: KviSysTrayClock(parent, __tr("UTC Clock"), "systray_utc_clock")
{
	// Nothing here
}

KviSysTrayUtcClock::~KviSysTrayUtcClock()
{
	// Nothing here
}

struct tm *KviSysTrayUtcClock::getTime(const time_t *timep)
{
	return gmtime(timep);
}

QString KviSysTrayUtcClock::icon()
{
	return SYSTRAY_ICON_UTC_CLOCK;
}

#include "m_kvi_systray_utcclock.moc"
