// =============================================================================
//
//   Copyright (C) 1999-2000 Szymon Stefanek
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviStyleBasic"

#include <qdrawutil.h>
#include <qmenudata.h>
#include <qpainter.h>
#include <qpixmap.h>

#include "kvi_colorbutton.h"
#include "kvi_pushbutton.h"
#include "kvi_style_basic.h"

extern QPixmap *button_pix;
extern QPixmap *button_def_pix;
extern QPixmap *arrow_pix;
extern QPixmap *check_pix;

KviBasicStyle::KviBasicStyle()
	: QPlatinumStyle()
{
	// Nothing here
}

KviBasicStyle::~KviBasicStyle()
{
	// Nothing here
}

void KviBasicStyle::polish(QWidget *w)
{
	if( w->inherits("KviColorButton") )
		((KviColorButton *) w)->setText("Colour");
}

void KviBasicStyle::unPolish(QWidget *w)
{
	if( w->inherits("KviColorButton") )
		((KviColorButton *) w)->setText("");
}

void KviBasicStyle::drawBasicShape(
	QPainter *pa, const QColorGroup &g,
	int x1, int y1, int x2, int y2, bool bSunken, bool bEnabled, bool bSpecial, bool bDoubleBorder)
{
	int rectX1 = x1 + 1;
	int rectY1 = y1 + 1;

	pa->fillRect(rectX1, rectY1, (x2 - x1) - 1, (y2 - y1) - 1, Qt::black);

	if( bDoubleBorder ) {
		rectX1++;
		rectY1++;
	}

	int hPix = button_pix->height();
	if( hPix > ((y2 - y1) - 1) )
		hPix = ((y2 - y1) - 1);

	if( bEnabled ) {
		if( bSpecial )
			bitBlt(pa->device(), rectX1, rectY1, button_def_pix, 0, 0, button_def_pix->width(), hPix);
		else
			bitBlt(pa->device(), rectX1, rectY1, button_pix, 0, 0, button_pix->width(), hPix);
	}
	qDrawShadeRect(pa, x1, y1, x2, y2, g, bSunken && bDoubleBorder);
	if( bDoubleBorder )
		qDrawShadeRect(pa, x1 + 1, y1 + 1, x2 - 1, y2 - 1, g, !bSunken);
}

void KviBasicStyle::drawPushButton(KviPushButton *b, QPainter *p)
{
	int x1, y1, x2, y2;
	b->rect().coords(&x1, &y1, &x2, &y2); // Get coordinates

	drawBasicShape(p, b->colorGroup(), x1, y1, x2, y2, b->isDown() || b->isOn(), b->isEnabled(), b->isDefault());
}

void KviBasicStyle::drawPushButtonLabel(KviPushButton *btn, QPainter *p)
{
	int x, y, w, h;
	btn->rect().rect(&x, &y, &w, &h);
	x += 3;
	y += 3;
	w -= 6;
	h -= 6;
	if( btn->isDown() || btn->isOn() ) {
		x++;
		y++;
		w--;
		h--;
	}
	QRect r(x, y, w, h);
	drawItem(
		p, r, AlignCenter | ShowPrefix, btn->colorGroup(), btn->isEnabled(), btn->pixmap(), btn->text(), -1,
		(btn->isDown() || btn->isOn()) ? &Qt::yellow : (btn->isDefault() ? &Qt::white : &(btn->colorGroup().background()))
	);
}

void KviBasicStyle::drawPopupMenuItem(
	QPainter *p, bool checkable, int maxpmw, int tab, QMenuItem *mi,
	const QPalette &pal, bool act, bool enabled, int x, int y, int w, int h
)
{
	QColorGroup g = ((!enabled) ? (act ? pal.active() : pal.inactive()) : pal.disabled());
#if 0 // TODO: enable this?
	if( checkable )
		maxpmw = QMAX(maxpmw, 12); // Space for the checkmarks
	int checkcol = maxpmw;
#endif

	if( mi->isSeparator() ) { // Draw separator
		p->setPen(Qt::red.light());
		p->drawLine(x, y, x + w, y);
		p->setPen(Qt::red.dark());
		p->drawLine(x, y + 1, x + w, y + 1);
		return;
	}

	p->fillRect(
		x + 1, y + 1, h - 3, h - 3,
		(act && enabled) ? (g.brush(QColorGroup::Midlight)) : g.brush(QColorGroup::Button)
	);
	qDrawShadeRect(p, x, y, x + h - 1, y + h - 1, g, false);

	drawBasicShape(p, g, x + h, y, x + w - 1, y + h - 1, false, enabled, act, false);

	if( mi->iconSet() ) {
		QIconSet::Mode mode = (!enabled) ? QIconSet::Disabled : QIconSet::Normal;
		if( act && enabled )
			mode = QIconSet::Active;
		QPixmap pixmap = mi->iconSet()->pixmap(QIconSet::Small, mode);
		int pixw = pixmap.width();
		int pixh = pixmap.height();
		QRect cr(x, y, h, h);
		QRect pmr(0, 0, pixw, pixh);
		pmr.moveCenter(cr.center());
		p->drawPixmap(pmr.topLeft(), pixmap);
	}

	if( mi->isChecked() ) {
		int dist = (h - 12) >> 1;
		QPoint pnt(x + w - (12 + dist), y + dist);
		p->drawPixmap(pnt, *check_pix);
	} else if( mi->popup() ) {
		int dist = (h - 12) >> 1;
		QPoint pnt(x + w - (12 + dist), y + dist);
		p->drawPixmap(pnt, *arrow_pix);
	}

	QString s = mi->text();
	QColor lightBlue(40, 150, 250);
	p->setPen(enabled ? (act ? lightBlue : Qt::lightGray) : Qt::darkGray);
	if( !s.isNull() )
		p->drawText(x + h + 5, y + 1, w - (h + 12), h - 2, AlignCenter | ShowPrefix | DontClip | SingleLine, s);
}

#include "m_kvi_style_basic.moc"
