#ifndef _KVI_DEFAULTS_H_
#define _KVI_DEFAULTS_H_

//=============================================================================
//
//   File : kvi_defaults.h
//   Creation date : Wed Jun 21 2000 13:23:13 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

//=============================================================================
// This file contains (more or less) freely customizable compile time defaults
//
// You can safely play with the ones you understand the meaning of
//=============================================================================

#include "kvi_settings.h"

#ifdef COMPILE_ON_WINDOWS
	#define KVI_HOME_CONFIG_FILE_NAME "kvirc-" VERSION ".ini"
#else
	#define KVI_HOME_CONFIG_FILE_NAME ".kvirc-" VERSION ".rc"
#endif

#define KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME ".kvirc"
#define KVI_DEFAULT_INCOMING_SUBDIRECTORY_NAME "download"

#define KVI_SMALLICONS_IMAGELIB_NAME "kvi_smallicon_00.png"
#define KVI_SMALLICONS_IMAGELIB_PREFIX "kvi_smallicon_"
#define KVI_USERCHANSTATE_IMAGE_NAME "kvi_userchanstate.png"
#define KVI_ACTIVITYMETER_IMAGE_NAME "kvi_activitymeter.png"

#define KVI_CTCP_VERSION_REPLY "KVIrc " VERSION " " KVI_RELEASE_NAME " - " SOURCES_DATE " - build " \
			 BUILD_DATE " - " BUILD_FLAGS

#define KVI_CTCP_CLIENTINFO_VERSION "KVIrc " VERSION " " KVI_RELEASE_NAME

#define KVI_CTCP_SOURCE_REPLY "KVIrc " VERSION " " KVI_RELEASE_NAME " http://www.kvirc.net/"

#define KVI_DEFAULT_FRAME_CAPTION "KVIrc " VERSION " " KVI_RELEASE_NAME

#define KVI_DEFAULT_NICKNAME1 "newbie"
#define KVI_DEFAULT_NICKNAME2 "[newbie]"
#define KVI_DEFAULT_NICKNAME3 "_newbie_"
#define KVI_DEFAULT_NICKNAME4 "newbie4"
#define KVI_DEFAULT_USERNAME "kvirc"
#define KVI_DEFAULT_REALNAME "Using KVIrc " VERSION " " KVI_RELEASE_NAME

#define KVI_DEFAULT_IDENTD_USER "kvirc"

#define KVI_DEFAULT_PART_MESSAGE "So Long, and Thanks for All the Fish!"
#define KVI_DEFAULT_QUIT_MESSAGE "KVIrc $version $version(r)"
#define KVI_DEFAULT_CTCP_USERINFO_REPLY "I'm too lazy to edit this field."
#define KVI_DEFAULT_CTCP_PAGE_REPLY "Your message has been received and logged"
#define KVI_DEFAULT_AWAY_MESSAGE "I'm off to see the wizard."
#define KVI_DEFAULT_AWAY_NICK "NotHere"

#ifdef COMPILE_SPLASH_SCREEN
	#define KVI_SPLASH_SCREEN_TEXT "KVIrc <b>" VERSION " " KVI_RELEASE_NAME "</b> by the <b>KVIrc Development Team</b>"
	#define KVI_SPLASH_SCREEN_MINIMUM_TIMEOUT_IN_MSECS 4000
#endif

#define KVI_ABOUT_DIALOG_TEXT "KVIrc <b>" VERSION " " KVI_RELEASE_NAME "</b>"

#define KVI_MAX_PENDING_AVATARS 20
#define KVI_MAX_RECENT_SERVERS 10
#define KVI_MAX_RECENT_CHANNELS 30
#define KVI_MAX_RECENT_NICKNAMES 10
#define KVI_RECENT_TOPIC_ENTRIES 20

#endif //_KVI_DEFAULTS_H_
