#ifndef _KVI_QSTRING_H_
#define _KVI_QSTRING_H_

//=============================================================================
//
//   File : kvi_qstring.h
//   Creation date : Mon Aug 04 2003 13:36:33 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

//=============================================================================
//
// Helper functions for the QString class
//
//=============================================================================

#include "kvi_settings.h"

#include "kvi_stdarg.h"

#include <qstring.h>

namespace KviQString
{
	extern KVILIB_API bool equalCS(const QString &sz1,const QString &sz2);
	extern KVILIB_API bool equalCI(const QString &sz1,const QString &sz2);
	extern KVILIB_API bool equalCS(const QString &sz1,const char * sz2);
	extern KVILIB_API bool equalCI(const QString &sz1,const char * sz2);
	inline bool equalCS(const char * sz1,const QString &sz2)
		{ return equalCS(sz2,sz1); };
	inline bool equalCI(const char * sz1,const QString &sz2)
		{ return equalCI(sz2,sz1); };

	extern KVILIB_API bool equalCSN(const QString &sz1,const QString &sz2,unsigned int len);
	extern KVILIB_API bool equalCIN(const QString &sz1,const QString &sz2,unsigned int len);
	extern KVILIB_API bool equalCSN(const QString &sz1,const char * sz2,unsigned int len);
	extern KVILIB_API bool equalCIN(const QString &sz1,const char * sz2,unsigned int len);
	inline bool equalCSN(const char * sz1,const QString &sz2,unsigned int len)
		{ return equalCSN(sz2,sz1,len); };
	inline bool equalCIN(const char * sz1,const QString &sz2,unsigned int len)
		{ return equalCIN(sz2,sz1,len); };

	//note that greater here means that come AFTER in the alphabetic order
	// return < 0 ---> str1 < str2
	// return = 0 ---> str1 = str2
	// return > 0 ---> str1 > str2
	extern KVILIB_API int cmpCI(const QString &sz1,const QString &sz2);
	extern KVILIB_API int cmpCIN(const QString &sz1,const QString &sz2,unsigned int len);
	extern KVILIB_API int cmpCS(const QString &sz1,const QString &sz2);

	extern KVILIB_API void detach(QString &sz);

	// this makes the QString sz appear as a null terminated array
	// it MAY RETURN 0 when the QString is null!
	extern KVILIB_API const QChar * nullTerminatedArray(const QString &sz);

	inline bool lastCharIs(QString &szString,const QChar &c)
					{ return szString.endsWith(c); };

	extern KVILIB_API void ensureLastCharIs(QString &szString,const QChar &c);

	extern KVILIB_API bool matchWildExpressionsCI(const QString &szM1,const QString &szM2);
	extern KVILIB_API bool matchStringCI(const QString &szExp,const QString &szStr);

	extern KVILIB_API void vsprintf(QString &s,const QString &szFmt,kvi_va_list list);
	extern KVILIB_API QString & sprintf(QString &s,const QString &szFmt,...);
	extern KVILIB_API void stripRightWhiteSpace(QString &s);
	extern KVILIB_API void appendFormatted(QString &s,const QString &szFmt,...);
	extern KVILIB_API void appendNumber(QString &s,double dReal);
	extern KVILIB_API void appendNumber(QString &s,int iInteger);
	extern KVILIB_API void appendNumber(QString &s,unsigned int uInteger);
	
	extern KVILIB_API void cutFromFirst(QString &s,const QChar &c,bool bIncluded = true);
	extern KVILIB_API void cutFromLast(QString &s,const QChar &c,bool bIncluded = true);
	extern KVILIB_API void cutToFirst(QString &s,const QChar &c,bool bIncluded = true,bool bClearIfNotFound = false);
	extern KVILIB_API void cutToLast(QString &s,const QChar &c,bool bIncluded = true,bool bClearIfNotFound = false);
	extern KVILIB_API void cutFromFirst(QString &s,const QString &c,bool bIncluded = true);
	extern KVILIB_API void cutFromLast(QString &s,const QString &c,bool bIncluded = true);
	extern KVILIB_API void cutToFirst(QString &s,const QString &c,bool bIncluded = true,bool bClearIfNotFound = false);
	extern KVILIB_API void cutToLast(QString &s,const QString &c,bool bIncluded = true,bool bClearIfNotFound = false);
};


#endif //!_KVI_QSTRING_H_
