//=============================================================================
//
//   File : kvi_ircconnectionserverinfo.cpp
//   Created on Tue 22 Jun 2004 03:57:32 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_ircconnectionserverinfo.h"

KviIrcConnectionServerInfo::KviIrcConnectionServerInfo()
{
	// default assumptions
	m_szSupportedChannelTypes = "#&!+";
	m_szSupportedModePrefixes = "@+";
	buildModePrefixTable();
	m_szSupportedModeFlags = "ov";
	m_bSupportsModesIe   = true;
	m_bSupportsWatchList = false;
	m_bSupportsCodePages = false;
}

KviIrcConnectionServerInfo::~KviIrcConnectionServerInfo()
{
}

void KviIrcConnectionServerInfo::setSupportedChannelModes(const QString &szSupportedChannelModes)
{
	m_szSupportedChannelModes = szSupportedChannelModes;
	m_bSupportsModesIe = (szSupportedChannelModes.contains('e') && szSupportedChannelModes.contains('I'));
}

void KviIrcConnectionServerInfo::setSupportedModePrefixes(const QString &szSupportedModePrefixes)
{
	m_szSupportedModePrefixes = szSupportedModePrefixes;
	buildModePrefixTable();
}

void KviIrcConnectionServerInfo::buildModePrefixTable()
{
	for(int i=0;i<KVI_NUM_POSSIBLE_MODE_PREFIX_CHARS;i++)
	{
		m_cModePrefixTable[i] = 0;
	}
	const QChar * c = KviQString::nullTerminatedArray(m_szSupportedModePrefixes);
	if(!c)return; // eh ?
	
	unsigned short uc;

	unsigned char level = 1; // we keep track of the order too (still unused tough)
	// FIXME: The whole mode handling needs rethinking!
	while((uc = c->unicode()))
	{
		if(uc < KVI_NUM_POSSIBLE_MODE_PREFIX_CHARS)
		{
			m_cModePrefixTable[uc] = level;
			level++;
		}
		c++;
	}
}

