//=============================================================================
//
//   File : kvi_kvs_coresimplecommands_af.cpp
//   Created on Fri 31 Oct 2003 00:04:25 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_coresimplecommands.h"


#include "kvi_window.h"
#include "kvi_out.h"
#include "kvi_locale.h"
#include "kvi_app.h"
#include "kvi_options.h"
#include "kvi_ircview.h" // this is only for KviIrcView::NoTimestamp


namespace KviKvsCoreSimpleCommands
{
	/*
		@doc: echo
		@type:
			command
		@title:
			echo
		@syntax:
			echo [-w=<window_id>] [-i=<icon_number>] [-n] <text>
		@short:
			Outputs text to a KVirc window
		@switches:
			!sw: -w=<window_id> | --window=<window_id>
			Causes the output to be redirected to the window specified by &lt;window_id&gt
			!sw: -i=<icon_number> | --icon=<icon_number>
			Causes the output to use the icon & color scheme specified by &lt;icon_number&gt
			!sw: -n | --no-timestamp
			Disables the message timestamping
		@description:
			Outputs the &lt;text&gt; to the current window.[br]
			If the 'w' switch is present , outputs the &lt;text&gt;
			to the specified window instead of the current one.
			The <window_id&> parameter is the [doc:window_naming_conventions]global ID[/doc] of the window
			that has to be used.[br]
			If the 'i' switch is given , it uses the specified
			icon scheme (icon and colors) , otherwise it uses
			the default one (0).[br]
			The KVIrc view widgets support clickable links that can be realized by using special [doc:escape_sequences]escape sequences[/doc].[br]
			The 'n' switch disables timestamping so you can output your own timestamp
			or not timestamp at all.[br]
		@examples:
			[example]
			echo Hey! this is my first echo test!
			echo -i=10 This text has a specified icon and colors
			echo --icon=[fnc]$icon[/fnc](parser error) this has the colors of the parser error messages
			[/example]
		@seealso:
			[fnc]$window[/fnc],
			[doc:window_naming_conventions]window naming conventions documentation[/doc]
	*/

	_KVS_CORESIMPLECOMMAND(echo)
	{
		QString szAll;
		pParams->allAsString(szAll);

		int iMsgType = KVI_OUT_NONE;
		KviWindow * pWnd = c->window();

		if(!pSwitches->isEmpty())
		{
			KviKvsVariant * v;
			if((v = pSwitches->find('w',"window")))
			{
				QString szWnd;
				v->asString(szWnd);
	//#warning "FIXME: the window database is not unicode! (we even could keep integer window id's at this point!)"
				pWnd = g_pApp->findWindow(szWnd.latin1());
				if(!pWnd)
				{
					c->warning(__tr2qs("The argument of the -w switch did not evaluate to a valid window id: using default"));
					pWnd = c->window();
				}
			}
				
			if((v = pSwitches->find('i',"icon")))
			{
				if(!v->asInteger(iMsgType))
				{
					c->warning(__tr2qs("The argument of the i switch did not evaluate to a number: using default"));
					iMsgType = KVI_OUT_NONE;
				} else {
					iMsgType = iMsgType % KVI_NUM_MSGTYPE_OPTIONS;
				}
			}
		}

		int iFlags = pSwitches->find('n',"no-timestamp") ? KviIrcView::NoTimestamp : 0;
		pWnd->outputNoFmt(iMsgType,szAll,iFlags);
		return true;
	}
};

