//=============================================================================
//
//   File : kvi_kvs_kernel.cpp
//   Creation date : Tue 30 Sep 2003 05.12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_kernel.h"
#include "kvi_kvs_parser.h"
#include "kvi_kvs_hash.h"
#include "kvi_kvs_coresimplecommands.h"
#include "kvi_kvs_corefunctions.h"
#include "kvi_kvs_corecallbackcommands.h"
#include "kvi_kvs_switchlist.h"
#include "kvi_kvs_variantlist.h"
#include "kvi_kvs_script.h"

KviKvsKernel * KviKvsKernel::m_pKvsKernel = 0;

////////////////////////////////////////////////////////////////////////////////
// CONSTRUCTION AND DESTRUCTION

KviKvsKernel::KviKvsKernel()
{
	m_pKvsKernel = this;

	m_pSpecialCommandParsingRoutineDict = new QDict<KviKvsSpecialCommandParsingRoutine>(17,false);
	m_pSpecialCommandParsingRoutineDict->setAutoDelete(true);
	m_pCoreSimpleCommandExecRoutineDict = new QDict<KviKvsCoreSimpleCommandExecRoutine>(51,false);
	m_pCoreSimpleCommandExecRoutineDict->setAutoDelete(true);
	m_pCoreFunctionExecRoutineDict = new QDict<KviKvsCoreFunctionExecRoutine>(51,false);
	m_pCoreFunctionExecRoutineDict->setAutoDelete(true);
	m_pCoreCallbackCommandExecRoutineDict = new QDict<KviKvsCoreCallbackCommandExecRoutine>(17,false);
	m_pCoreCallbackCommandExecRoutineDict->setAutoDelete(true);

	m_pGlobalVariables = new KviKvsHash();
	m_pEmptyParameterList = new KviKvsVariantList();
	
	KviKvsParser::init();

	KviKvsCoreSimpleCommands::init();
	KviKvsCoreFunctions::init();
	KviKvsCoreCallbackCommands::init();
}

KviKvsKernel::~KviKvsKernel()
{
	delete m_pEmptyParameterList;
	delete m_pGlobalVariables;

	delete m_pSpecialCommandParsingRoutineDict;
	delete m_pCoreSimpleCommandExecRoutineDict;
	delete m_pCoreFunctionExecRoutineDict;
	delete m_pCoreCallbackCommandExecRoutineDict;
}

////////////////////////////////////////////////////////////////////////////////
// INSTANCE MANAGEMENT

void KviKvsKernel::init()
{
	if(!m_pKvsKernel)m_pKvsKernel = new KviKvsKernel();
}

void KviKvsKernel::done()
{
	if(m_pKvsKernel)
	{
		delete m_pKvsKernel;
		m_pKvsKernel = 0;
	}
}

