//=============================================================================
//
//   File : kvi_kvs_reporttarget.cpp
//   Created on Wed 29 Oct 2003 04:39:54 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_reporttarget.h"
#include "kvi_locale.h"

KviKvsReportTarget::KviKvsReportTarget()
{
	m_bError = false;
	m_pReportList = 0;
	m_pDefaultLocation = 0;
}

KviKvsReportTarget::~KviKvsReportTarget()
{
	if(m_pReportList)delete m_pReportList;
}

void KviKvsReportTarget::setDefaultReportLocation(const QChar * pLocation)
{
	m_pDefaultLocation = pLocation;
}

void KviKvsReportTarget::error(const QChar * pLocation,const QString &szMessageFmt,...)
{
	m_bError = true;
	kvi_va_list va;
	kvi_va_start_by_reference(va,szMessageFmt);
	report(KviKvsReport::Error,pLocation,szMessageFmt,va);
	kvi_va_end(va);
}


void KviKvsReportTarget::warning(const QChar * pLocation,const QString &szMessageFmt,...)
{
	kvi_va_list va;
	kvi_va_start_by_reference(va,szMessageFmt);
	report(KviKvsReport::Warning,pLocation,szMessageFmt,va);
	kvi_va_end(va);
}

void KviKvsReportTarget::error(const QString &szMessageFmt,...)
{
	m_bError = true;
	kvi_va_list va;
	kvi_va_start_by_reference(va,szMessageFmt);
	report(KviKvsReport::Error,m_pDefaultLocation,szMessageFmt,va);
	kvi_va_end(va);
}


void KviKvsReportTarget::warning(const QString &szMessageFmt,...)
{
	kvi_va_list va;
	kvi_va_start_by_reference(va,szMessageFmt);
	report(KviKvsReport::Warning,m_pDefaultLocation,szMessageFmt,va);
	kvi_va_end(va);
}

void KviKvsReportTarget::report(KviKvsReport::Type t,const QChar * pLocation,const QString &szMessageFmt,kvi_va_list va)
{
	if(!m_pReportList)
	{
		m_pReportList = new KviPtrList<KviKvsReport>();
		m_pReportList->setAutoDelete(true);
	}

	QString szMsg;
	KviQString::vsprintf(szMsg,szMessageFmt,va);

	m_pReportList->append(new KviKvsReport(t,pLocation,szMsg));
}


void KviKvsReportTarget::errorBadChar(const QChar * pLocation,char cExpected,const char * szCommandName)
{
	error(pLocation,__tr2qs("Found character '%q' (unicode 0x%x) where '%c' was expected: see \"/help %s\" for the command syntax"),
		pLocation,pLocation,pLocation->unicode(),cExpected,szCommandName);
}

bool KviKvsReportTarget::errorNoIrcContext()
{
	error(m_pDefaultLocation,__tr2qs("This command can be used only in windows bound to an IRC context"));
	return false;
}

bool KviKvsReportTarget::warningNoIrcConnection()
{
	warning(m_pDefaultLocation,__tr2qs("You're not connected to an IRC server"));
	return true;
}

bool KviKvsReportTarget::warningMissingParameter()
{
	warning(m_pDefaultLocation,__tr2qs("Missing parameter"));
	return true;
}
