//=============================================================================
//
//   File : kvi_kvs_runtimecontext.cpp
//   Created on Tue 07 Oct 2003 01:49:40 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_runtimecontext.h"
#include "kvi_kvs_script.h"
#include "kvi_kvs_kernel.h"
#include "kvi_console.h"

#include "kvi_app.h"

KviKvsRunTimeContext::KviKvsRunTimeContext(KviKvsScript * pScript,KviWindow * pWnd,KviKvsVariantList * pParams,KviKvsVariant * pRetVal,KviKvsExtendedRunTimeData * pExtData)
: KviKvsReportTarget()
{
	m_pScript = pScript;
	m_pParameterList = pParams;
	m_pWindow = pWnd;
	m_pLocalVariables = new KviKvsHash();
	m_pReturnValue = pRetVal;
	m_uRunTimeFlags = 0;
	m_pExtendedData = pExtData;
}

KviKvsRunTimeContext::~KviKvsRunTimeContext()
{
	delete m_pLocalVariables;
}

KviKvsHash * KviKvsRunTimeContext::globalVariables()
{
	return KviKvsKernel::instance()->globalVariables();
}

void KviKvsRunTimeContext::enterBlockingSection()
{
	// actually a NO-OP
}

bool KviKvsRunTimeContext::leaveBlockingSection()
{
	if(g_pApp->closingDown())return false;            // application quitting
	if(!g_pApp->windowExists(m_pWindow))return false; // window lost
	return true;
}

KviKvsVariant * KviKvsRunTimeContext::swapReturnValuePointer(KviKvsVariant * pNewPointer)
{
	KviKvsVariant * pAux = m_pReturnValue;
	m_pReturnValue = pNewPointer;
	return pAux;
}
