#ifndef _KVI_KVS_SCRIPT_H_
#define _KVI_KVS_SCRIPT_H_
//=============================================================================
//
//   File : kvi_kvs_script.h
//   Creation date : Thu 25 Sep 2003 05.12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"
#include "kvi_window.h"
#include "kvi_list.h"
#include "kvi_kvs_report.h"
#include "kvi_kvs_variant.h"
#include "kvi_kvs_variantlist.h"
#include "kvi_heapobject.h"

class KviKvsTreeNodeInstruction;
class KviKvsExtendedRunTimeData;
class KviKvsReport;
class KviKvsScriptData;

class KVIRC_API KviKvsScript : public KviHeapObject
{
	friend class KviKvsRunTimeContext;
	friend class KviKvsParser;
public:
	enum ScriptType {
		// the most common script type: a sequence of instructions
		InstructionList,
		// an expression to be evaluated as in a $() call (pRetVal should be always set!)
		Expression,
		// a parameter to be evaluated (pRetVal should be always set!)
		Parameter
	};
protected:
	// this script becomes the owner of pszBuffer!
	// the name parameter is the name of the script context!
	KviKvsScript(const QString &szName,QString * pszBuffer,KviKvsTreeNodeInstruction * pPreparsedTree,ScriptType eType = InstructionList);
public:
	// shallow copy of the script data
	// useful when a script can be destroyed while running (like in timers)
	KviKvsScript(const KviKvsScript &src);
	// this script becomes the owner of pszBuffer!
	KviKvsScript(const QString &szName,QString * pszBuffer,ScriptType eType=InstructionList);
	~KviKvsScript();
private:
	KviKvsScriptData * m_pData;
public:
	const QString & name() const;
	const QString & code() const;
	bool locked() const;

	// WARNING: this changes the name for all the shallow copies
	// don't use it if you don't know what it does
	void setName(const QString &szName); 

	enum RunFlags {
		// do not delete the eventual parameters passed (only execute() and run())
		PreserveParams = 1,
		// assume that the variables are global unless explicitly declared (flag used only for parse())
		AssumeGlobals = 2
	};
	// returns true after a succesful run
	// returns false on a failed run (error)
	bool run(KviWindow * pWnd,                                // window that the command has to be bound to
				KviKvsVariantList * pParams = 0,              // parameter list (0 if you don't pass params) ownership transferred if PreserverParams is not used
				KviKvsVariant * pRetVal = 0,                  // return value buffer (0 if you ignore it)
				int iRunFlags = 0,                            // a combination of run flags (usually default)
				KviKvsExtendedRunTimeData * pExtData = 0);    // extended data (usually 0) (if you need to pass extended scope variables or alias switch lists...)
public:
	void dump(const char * prefix);
protected:
	// returns true after a succesfull parsing
	// pOutput is useful only for printing errors
	// if 0 , no errors are printed
	bool parse(KviWindow * pOutput = 0,
				int iRunFlags = 0);
	bool execute(KviWindow * pWnd,
				KviKvsVariantList * pParams = 0,
				KviKvsVariant * pRetVal = 0,
				int iRunFlags = 0,
				KviKvsExtendedRunTimeData * pExtData = 0);
	void printReportList(KviWindow * pOutput,KviPtrList<KviKvsReport> * pList,bool bRunTime);
};




#endif //!_KVI_KVS_SCRIPT_H_
