//=============================================================================
//
//   File : kvi_kvs_treenode_specialcommanddefpopup.cpp
//   Created on Fri 02 Jan 2004 14:09:00 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_kvs_treenode_specialcommanddefpopup.h"
#include "kvi_kvs_treenode_expression.h"
#include "kvi_kvs_treenode_instruction.h"
#include "kvi_kvs_runtimecontext.h"
#include "kvi_locale.h"
#include "kvi_kvs_popupmanager.h"
#include "kvi_kvs_popupmenu.h"
#include "kvi_kvs_script.h"

void KviKvsTreeNodeSpecialCommandDefpopupLabelExtpopup::dump(const char * prefix)
{
	debug("%s SpecialCommandDefpopupLabelExtpopup",prefix);
	QString tmp = prefix;
	tmp.append("  ");
	QString x = tmp;
	x += "CONDITION: ";
	x += m_szCondition;
	debug(x.latin1());
	x = tmp;
	x += "TEXT: ";
	x += m_szText;
	debug(x.latin1());
	x = tmp;
	x += "NAME: ";
	x += m_szName;
	debug(x.latin1());
	x = tmp;
	x += "ICON: ";
	x += m_szIcon;
	debug(x.latin1());
}

bool KviKvsTreeNodeSpecialCommandDefpopupLabelExtpopup::execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p)
{
	p->addExtPopup(m_szName,m_szText,m_szIcon,m_szCondition);
	return true;
}



void KviKvsTreeNodeSpecialCommandDefpopupLabelItem::dump(const char * prefix)
{
	debug("%s SpecialCommandDefpopupLabelItem",prefix);
	QString tmp = prefix;
	tmp.append("  ");
	QString x = tmp;
	x += "CONDITION: ";
	x += m_szCondition;
	debug(x.latin1());
	x = tmp;
	x += "TEXT: ";
	x += m_szText;
	debug(x.latin1());
	x = tmp;
	x += "ICON: ";
	x += m_szIcon;
	debug(x.latin1());
	x = tmp;
	x += "INSTRUCTION: ";
	x += m_szInstruction;
	debug(x.latin1());
}

bool KviKvsTreeNodeSpecialCommandDefpopupLabelItem::execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p)
{
	p->addItem(m_szInstruction,m_szText,m_szIcon,m_szCondition);
	return true;
}


void KviKvsTreeNodeSpecialCommandDefpopupLabelLabel::dump(const char * prefix)
{
	debug("%s SpecialCommandDefpopupLabelLabel",prefix);
	QString tmp = prefix;
	tmp.append("  ");
	QString x = tmp;
	x += "CONDITION: ";
	x += m_szCondition;
	debug(x.latin1());
	x = tmp;
	x += "TEXT: ";
	x += m_szText;
	debug(x.latin1());
	x = tmp;
	x += "ICON: ";
	x += m_szIcon;
	debug(x.latin1());
}

bool KviKvsTreeNodeSpecialCommandDefpopupLabelLabel::execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p)
{
	p->addLabel(m_szText,m_szIcon,m_szCondition);
	return true;
}






void KviKvsTreeNodeSpecialCommandDefpopupLabelSeparator::dump(const char * prefix)
{
	debug("%s SpecialCommandDefpopupLabelSeparator",prefix);
	QString tmp = prefix;
	tmp.append("  CONDITION:");
	tmp.append(m_szCondition);
	debug(tmp.latin1());
}

bool KviKvsTreeNodeSpecialCommandDefpopupLabelSeparator::execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p)
{
	p->addSeparator(m_szCondition);
	return true;
}





void KviKvsTreeNodeSpecialCommandDefpopupLabelEpilogue::dump(const char * prefix)
{
	debug("%s SpecialCommandDefpopupLabelEpilogue",prefix);
	QString tmp = prefix;
	tmp.append("  INSTRUCTION: ");
	tmp += m_szInstruction;
	debug(tmp.latin1());
}

bool KviKvsTreeNodeSpecialCommandDefpopupLabelEpilogue::execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p)
{
	p->addEpilogue(m_szInstruction);
	return true;
}





void KviKvsTreeNodeSpecialCommandDefpopupLabelPrologue::dump(const char * prefix)
{
	debug("%s SpecialCommandDefpopupLabelPrologue",prefix);
	QString tmp = prefix;
	tmp.append("  INSTRUCTION: ");
	tmp += m_szInstruction;
	debug(tmp.latin1());
}

bool KviKvsTreeNodeSpecialCommandDefpopupLabelPrologue::execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p)
{
	p->addPrologue(m_szInstruction);
	return true;
}









KviKvsTreeNodeSpecialCommandDefpopupLabelPopup::KviKvsTreeNodeSpecialCommandDefpopupLabelPopup(const QChar * pLocation)
: KviKvsTreeNodeSpecialCommandDefpopupConditionalLabelWithTextAndIcon(pLocation,QString::null,QString::null,QString::null)
{
	m_pLabels = new KviPtrList<KviKvsTreeNodeSpecialCommandDefpopupLabel>;
	m_pLabels->setAutoDelete(true);
}

KviKvsTreeNodeSpecialCommandDefpopupLabelPopup::~KviKvsTreeNodeSpecialCommandDefpopupLabelPopup()
{
	delete m_pLabels;
}

void KviKvsTreeNodeSpecialCommandDefpopupLabelPopup::dump(const char * prefix)
{
	debug("%s SpecialCommandDefpopupLabelPopup",prefix);
	QString tmp = prefix;
	tmp.append("  ");
	QString x = tmp;
	x += "CONDITION: ";
	x += m_szCondition;
	debug(x.latin1());
	x = tmp;
	x += "TEXT: ";
	x += m_szText;
	debug(x.latin1());
	x = tmp;
	x += "ICON: ";
	x += m_szIcon;
	debug(x.latin1());
	for(KviKvsTreeNodeSpecialCommandDefpopupLabel * l = m_pLabels->first();l;l = m_pLabels->next())
		l->dump(tmp.latin1());
}

void KviKvsTreeNodeSpecialCommandDefpopupLabelPopup::addLabel(KviKvsTreeNodeSpecialCommandDefpopupLabel * pLabel)
{
	pLabel->setParent(this);
	m_pLabels->append(pLabel);
}

bool KviKvsTreeNodeSpecialCommandDefpopupLabelPopup::execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p)
{
	// the name will be reset anyway
	KviKvsPopupMenu * pNew = p->addPopup(m_szText,m_szIcon,m_szCondition);
	return fill(c,pNew);
}

bool KviKvsTreeNodeSpecialCommandDefpopupLabelPopup::fill(KviKvsRunTimeContext* c,KviKvsPopupMenu * p)
{
	for(KviKvsTreeNodeSpecialCommandDefpopupLabel * l = m_pLabels->first();l;l = m_pLabels->next())
	{
		if(!l->execute(c,p))return false;
	}
	return true;
}








KviKvsTreeNodeSpecialCommandDefpopup::KviKvsTreeNodeSpecialCommandDefpopup(const QChar * pLocation,KviKvsTreeNodeData * pPopupName,KviKvsTreeNodeSpecialCommandDefpopupLabelPopup * pMainPopup)
: KviKvsTreeNodeSpecialCommand(pLocation,"defpopup")
{
	m_pPopupName = pPopupName;
	m_pPopupName->setParent(this);
	m_pMainPopup = pMainPopup;
	m_pMainPopup->setParent(this);
}

KviKvsTreeNodeSpecialCommandDefpopup::~KviKvsTreeNodeSpecialCommandDefpopup()
{
	delete m_pPopupName;
	delete m_pMainPopup;
}


void KviKvsTreeNodeSpecialCommandDefpopup::dump(const char * prefix)
{
	debug("%s SpecialCommandDefpopup",prefix);
	QString tmp = prefix;
	tmp.append("  ");
	m_pPopupName->dump(tmp.latin1());
	m_pMainPopup->dump(tmp.latin1());
}

bool KviKvsTreeNodeSpecialCommandDefpopup::execute(KviKvsRunTimeContext * c)
{
	KviKvsVariant v;
	if(!m_pPopupName->evaluateReadOnly(c,&v))return false;
	QString szName;
	v.asString(szName);

	KviKvsSwitchList swl;
	if(m_pSwitches)
	{
		if(!(m_pSwitches->evaluate(c,&swl)))return false;
	}

	KviKvsPopupMenu * pPopup = KviKvsPopupManager::instance()->lookup(szName);
	bool bWasAlreadyThere;
	if(!pPopup)
	{
		pPopup = new KviKvsPopupMenu(szName);
		KviKvsPopupManager::instance()->add(szName,pPopup);
		bWasAlreadyThere = false;
	} else {
		bWasAlreadyThere = true;

		if(pPopup->isLocked())
		{
			c->error(__tr2qs("The popup '%s' is actually locked: 'self-modifications' are not allowed"),&szName);
			return false;
		}

		if(!swl.find('m'))pPopup->doClear();
	}


	if(!m_pMainPopup->fill(c,pPopup))
	{
		if(!bWasAlreadyThere)KviKvsPopupManager::instance()->remove(szName);
		return false;
	}

	return true;
}
