//
//   File : kvi_modeeditor.cpp
//   Creation date : Sat Apr 14 2001 13:52:11 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__
#include "kvi_modeeditor.h"
#include "kvi_iconmanager.h"
#include "kvi_locale.h"
#include "kvi_qstring.h"

#include <qlayout.h>
#include <qlabel.h>


// kvi_sp_numeric.cpp
extern const QString & getChannelModeDescription(char c);

//////////////////////////////////////////////////////////////////////
// class KviModeEditor
//
//////////////////////////////////////////////////////////////////////

// add support for +c and +a ?

static char checkable_modes_table[KVI_NUM_CHECKABLE_MODES] = { 'p','s','t','n','m','i'};

KviModeEditor::KviModeEditor(QWidget * par,const char * nam,const char * mode,const char * key,const char * limit)
: QWidget(par,nam)
{
	m_szMode = mode;
	m_szKey = key;
	m_szLimit = limit;

	setFocusPolicy(QWidget::ClickFocus);

	QGridLayout *g = new QGridLayout(this,9 + KVI_NUM_CHECKABLE_MODES,3,2,2);

	QLabel * l = new QLabel("",this);
	l->setPixmap(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_MODE)));
	g->addWidget(l,0,0);

	l = new QLabel(__tr2qs("Channel Modes"),this);
	g->addMultiCellWidget(l,0,0,1,2);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addMultiCellWidget(f,1,1,0,2);

	int i;
	QString tmp;

	for(i=0;i<KVI_NUM_CHECKABLE_MODES;i++)
	{
		KviQString::sprintf(tmp,"%c: %Q",checkable_modes_table[i],&(getChannelModeDescription(checkable_modes_table[i])));
		m_pCheckBox[i] = new QCheckBox(tmp,this);
		m_pCheckBox[i]->setChecked(m_szMode.contains(checkable_modes_table[i]));
		g->addMultiCellWidget(m_pCheckBox[i],i + 2,i + 2,0,2);
	}
	KviQString::sprintf(tmp,"l: %Q",&(getChannelModeDescription('l')));
	m_pLimitBox = new QCheckBox(tmp,this);
	g->addMultiCellWidget(m_pLimitBox,i + 3,i + 3,0,2);
	connect(m_pLimitBox,SIGNAL(toggled(bool)),this,SLOT(limitBoxToggled(bool)));
	m_pLimitEdit = new QLineEdit(this);
	g->addMultiCellWidget(m_pLimitEdit,i + 4,i + 4,1,2);
	if(m_szLimit.hasData())
	{
		m_pLimitBox->setChecked(true);
//		m_pLimitEdit->setEnabled(true);
		m_pLimitEdit->setText(m_szLimit.ptr());
	} else {
		m_pLimitEdit->setEnabled(false);
	}

	KviQString::sprintf(tmp,"k: %Q",&(getChannelModeDescription('k')));
	m_pKeyBox = new QCheckBox(tmp,this);
	g->addMultiCellWidget(m_pKeyBox,i + 5,i + 5,0,2);
	connect(m_pKeyBox,SIGNAL(toggled(bool)),this,SLOT(keyBoxToggled(bool)));
	m_pKeyEdit = new QLineEdit(this);
	g->addMultiCellWidget(m_pKeyEdit,i + 6,i + 6,1,2);
	if(m_szKey.hasData())
	{
		m_pKeyBox->setChecked(true);
//		m_pLimitEdit->setEnabled(true);
		m_pKeyEdit->setText(m_szKey.ptr());
	} else {
		m_pKeyEdit->setEnabled(false);
	}


	QWidget * w = new QWidget(this);
	g->addMultiCellWidget(w,i + 7,i + 7,0,2);

	QPushButton * b = new QPushButton(__tr2qs("&Apply"),this);
	g->addMultiCellWidget(b,i + 8,i + 8,0,2);
	connect(b,SIGNAL(clicked()),this,SLOT(commit()));

	g->setRowStretch(i + 7,1);
	g->setColStretch(2,1);

}

KviModeEditor::~KviModeEditor()
{
}

void KviModeEditor::limitBoxToggled(bool bChecked)
{
	m_pLimitEdit->setEnabled(bChecked);
}

void KviModeEditor::keyBoxToggled(bool bChecked)
{
	m_pKeyEdit->setEnabled(bChecked);
}

void KviModeEditor::commit()
{
	KviStr szPlusModes;
	KviStr szMinusModes;

	if(m_szKey.hasData())
	{
		// had a key before
		if(m_pKeyBox->isChecked())
		{
			// still have it
			KviStr tmp = m_pKeyEdit->text();
			tmp.stripWhiteSpace();
			if(tmp.hasData())
			{
				if(!kvi_strEqualCI(tmp.ptr(),m_szKey.ptr()))
				{
					// not the same key!
					// set the new one
					KviStr mode(KviStr::Format,"-k %s",m_szKey.ptr());
					emit setMode(mode.ptr());
					mode.sprintf("+k %s",tmp.ptr());
					emit setMode(mode.ptr());
				}
			}
		} else {
			// no key now! reset
			KviStr mode(KviStr::Format,"-k %s",m_szKey.ptr());
			emit setMode(mode.ptr());
		}
	} else {
		// there was no key before
		if(m_pKeyBox->isChecked())
		{
			KviStr tmp = m_pKeyEdit->text();
			tmp.stripWhiteSpace();
			if(tmp.hasData())
			{
				// new key to be set
				KviStr mode(KviStr::Format,"+k %s",tmp.ptr());
				emit setMode(mode.ptr());
			}
		}
	}

	if(m_szLimit.hasData())
	{
		// had a limit before
		if(m_pLimitBox->isChecked())
		{
			// still have it
			KviStr tmp = m_pLimitEdit->text();
			tmp.stripWhiteSpace();
			if(tmp.hasData() && tmp.isUnsignedNum())
			{
				if(!kvi_strEqualCI(tmp.ptr(),m_szLimit.ptr()))
				{
					// not the same limit!
					KviStr mode(KviStr::Format,"+l %s",tmp.ptr());
					emit setMode(mode.ptr());
				}
			}
		} else {
			// no limit now! reset
			szMinusModes.append('l');
		}
	} else {
		// there was no limit before
		if(m_pLimitBox->isChecked())
		{
			KviStr tmp = m_pLimitEdit->text();
			tmp.stripWhiteSpace();
			if(tmp.hasData() && tmp.isUnsignedNum())
			{
				// new limit to be set
				KviStr mode(KviStr::Format,"+l %s",tmp.ptr());
				emit setMode(mode.ptr());
			}
		}
	}
	int i;



	for(i = 0;i< KVI_NUM_CHECKABLE_MODES;i++)
	{
		if(m_pCheckBox[i]->isChecked())
		{
			if(!m_szMode.contains(checkable_modes_table[i]))szPlusModes.append(checkable_modes_table[i]);
		} else {
			if(m_szMode.contains(checkable_modes_table[i]))szMinusModes.append(checkable_modes_table[i]);
		}
	}

	KviStr szModes;

	if(szMinusModes.hasData())szModes.sprintf("-%s",szMinusModes.ptr());
	if(szPlusModes.hasData())szModes.append(KviStr::Format,"+%s",szPlusModes.ptr());
	if(szModes.hasData())emit setMode(szModes.ptr());

	emit done();
}

#include "kvi_modeeditor.moc"
