#ifndef _KVI_SELECTORS_H_
#define _KVI_SELECTORS_H_

//=============================================================================
//
//   File : kvi_selectors.h
//   Creation date : Mon Now 13 2000 15:21:10 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================


#include "kvi_settings.h"

#include <qcheckbox.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qscrollview.h>
#include <qpushbutton.h>
#include <qcolor.h>
#include <qfont.h>
#include <qlistbox.h>
#include <qspinbox.h>
#include <qstringlist.h>
#include <qvalidator.h>

#include "kvi_string.h"
#include "kvi_pixmap.h"

//#ifndef _KVI_SELECTORS_CPP_
//	extern void commitAllSelectors(QWidget * par,const char * classname);
//#endif


//
// This is the common KviSelectorInterface
//
//     Note: I'm always learning
//           Today I have discovered that:
//              QObject * o = new KviBoolSelector(...)
//              ((KviSelectorInterface *)o)->commit()
//           Does not work (SIGSEGV when jumping into commit(): bad vtable entry)
//           But the following works fine:
//              KviBoolSelector * b = new KviBoolSelector(...)
//              ((KviSelectorInterface *)b)->commit();
//           Mmmmmh.... the assembler generated by gcc
//           uses two different vtable offsets in the two cases
//           why ?
//

class KVIRC_API KviSelectorInterface
{
public:
	KviSelectorInterface(){};
	virtual ~KviSelectorInterface(){};
public:
	virtual void commit(){};
};

class KVIRC_API KviBoolSelector : public QCheckBox, public KviSelectorInterface
{
	Q_OBJECT
public:
	KviBoolSelector(QWidget * par,const QString & txt,bool *pOption,bool bEnabled);
	~KviBoolSelector(){};
private:
	bool * m_pOption;
public:
	virtual void commit();
public slots:
	void setNotEnabled(bool bNotEnabled);
};

class KVIRC_API KviStringSelector : public QHBox, public KviSelectorInterface
{
	Q_OBJECT
public:
	KviStringSelector(QWidget * par,const QString & txt,QString * pOption,bool bEnabled);
	~KviStringSelector();
protected:
	QLabel    * m_pLabel;
	QLineEdit * m_pLineEdit;
	QString    * m_pOption;
public:
	void setValidator(QValidator * v){ m_pLineEdit->setValidator(v); };
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
};


class KVIRC_API KviPasswordSelector : public KviStringSelector
{
	Q_OBJECT
public:
	KviPasswordSelector(QWidget * par,const QString & txt,QString * pOption,bool bEnabled);
	~KviPasswordSelector(){};
};

class KVIRC_API KviPixmapPreview : public QScrollView
{
	Q_OBJECT
public:
	KviPixmapPreview(QWidget * par);
	~KviPixmapPreview();
protected:
	KviPixmap * m_pPixmap;
public:
	void setPixmap(KviPixmap * pix);
protected:
	virtual void drawContents(QPainter * p, int clipx, int clipy, int clipw, int cliph);

};

class KVIRC_API KviPixmapSelector : public QWidget, public KviSelectorInterface
{
	Q_OBJECT
public:
	KviPixmapSelector(QWidget * par,const QString & txt,KviPixmap * pOption,bool bEnabled);
	~KviPixmapSelector();
private:
	QCheckBox        * m_pCheckBox;
	QLabel           * m_pFileNameLabel;
	KviPixmapPreview * m_pPreview;
	QPushButton      * m_pChooseButton;
	KviPixmap        * m_pOption;
	KviPixmap          m_localPixmap;
public:
	void setImagePath(const char * path);
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
protected slots:
	void checkBoxToggled(bool bEnabled);
	void choosePixmap();
};

class KVIRC_API KviUIntSelector : public QHBox, public KviSelectorInterface
{
	Q_OBJECT
public:
	KviUIntSelector(QWidget * par,const QString & txt,unsigned int *pOption,
		unsigned int uLowBound,unsigned int uHighBound,unsigned int uDefault,bool bEnabled,bool bShortInt = false);
	~KviUIntSelector(){};
private:
	QLabel    * m_pLabel;
	QSpinBox  * m_pSpinBox;
	unsigned int * m_pOption;
	unsigned int m_uLowBound;
	unsigned int m_uHighBound;
	unsigned int m_uDefault;
	bool         m_bIsShortInt;
public:
	virtual void setPrefix(const QString & txt);
	virtual void setSuffix(const QString & txt);
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
};


class KVIRC_API KviFileSelector : public QHBox, public KviSelectorInterface
{
	Q_OBJECT
public:
	KviFileSelector(QWidget * par,const QString & txt,QString * pOption,bool bEnabled);
	~KviFileSelector(){};
protected:
	QLabel      * m_pLabel;
	QLineEdit   * m_pLineEdit;
	QPushButton * m_pButton;
	QString     * m_pOption;
public:
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
private slots:
	void browseClicked();
protected:
	virtual void select();
};

class KVIRC_API KviDirectorySelector : public KviFileSelector
{
	Q_OBJECT
public:
	KviDirectorySelector(QWidget * par,const QString & txt,QString * pOption,bool bEnabled);
	~KviDirectorySelector(){};
protected:
	virtual void select();
};


class KVIRC_API KviColorSelector : public QHBox, public KviSelectorInterface
{
	Q_OBJECT
public:
	KviColorSelector(QWidget * par,const QString & txt,QColor * pOption,bool bEnabled);
	~KviColorSelector(){};
private:
	QLabel      * m_pLabel;
	QColor      * m_pOption;
	QColor        m_memColor;
	QPushButton * m_pButton;
public:
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
	QColor getColor(){ return m_memColor; };
	void forceColor(QColor clr);
private:
	void setButtonPalette(QColor * pOption);
private slots:
	void changeClicked();
};

class KVIRC_API KviFontSelector : public QHBox, public KviSelectorInterface
{
	Q_OBJECT
public:
	KviFontSelector(QWidget * par,const QString & txt,QFont * pOption,bool bEnabled);
	~KviFontSelector(){};
private:
	QLabel      * m_pLabel;
	QFont       * m_pOption;
	QPushButton * m_pButton;
public:
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
private:
	void setButtonFont(QFont * pOption);
private slots:
	void changeClicked();
};

class KVIRC_API KviStringListSelector : public QVBox, public KviSelectorInterface
{
	Q_OBJECT
public:
	KviStringListSelector(QWidget * par,const QString & txt,QStringList * pOption,bool bEnabled);
	~KviStringListSelector();
private:
	QLabel      * m_pLabel;
	QListBox    * m_pListBox;
	QLineEdit   * m_pLineEdit;
	QPushButton * m_pAddButton;
	QPushButton * m_pRemoveButton;
	QStringList * m_pOption;
public:
	virtual void commit();
	virtual void setEnabled(bool bEnabled);
private slots:
	void textChanged(const QString &str);
	void selectionChanged();
	void addClicked();
	void removeClicked();
};



#endif //!_KVI_SELECTORS_H_
