//
//   File : kvi_event.cpp
//   Creation date : Thu Aug 17 2000 16:42:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

/*
#define __KVIRC__

#define _KVI_EVENT_CPP_
#include "kvi_event.h"
#include "kvi_eventhandler.h"
#include "kvi_config.h"

#include "kvi_qstring.h"

// FIXME: #warning "DOCS FOR THE EVENTS!"

// FIXME: OnSpam ??
//




KviEventManager * g_pEventManager = 0;

KviEventManager::KviEventManager()
{
	for(int i=0;i<1000;i++)m_rawNumericEventTable[i] = 0;
}

KviEventManager::~KviEventManager()
{
	clear();
}

#define EVENT(_name,_parm) KviEventStruct(_name,_parm,0)

KviEventStruct KviEventManager::m_eventTable[KVI_NUM_SCRIPT_EVENTS]=
{
};

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Clear functions
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void KviEventManager::clear()
{
	int i;
	for(i = 0;i < KVI_NUM_SCRIPT_EVENTS;i++)
	{
		if(m_eventTable[i].handlers)
		{
			delete m_eventTable[i].handlers;
			m_eventTable[i].handlers = 0;
		}
	}
	for(i = 0;i < 1000;i++)
	{
		delete m_rawNumericEventTable[i];
		m_rawNumericEventTable[i] = 0;
	}
}

void KviEventManager::clearScriptHandlers(KviEventHandlerList * l)
{
	KviEventHandlerList dl;
	dl.setAutoDelete(false);
	KviEventHandler * e;
	for(e = l->first();e;e = l->next())
	{
		if(e->type() == KviEventHandler::Script)dl.append(e);
	}
	for(e = dl.first();e;e = dl.next())
	{
		l->removeRef(e);
	}
}

void KviEventManager::clearScriptHandlers()
{
	for(int i=0;i< KVI_NUM_SCRIPT_EVENTS;i++)
	{
		if(m_eventTable[i].handlers)
		{
			clearScriptHandlers(m_eventTable[i].handlers);
			if(m_eventTable[i].handlers->isEmpty())
			{
				delete m_eventTable[i].handlers;
				m_eventTable[i].handlers = 0;
			}
		}
	}
}

void KviEventManager::clearRawScriptHandlers()
{
	for(int i=0;i< 1000;i++)
	{
		if(m_rawNumericEventTable[i])
		{
			clearScriptHandlers(m_rawNumericEventTable[i]);
			if(m_rawNumericEventTable[i]->isEmpty())
			{
				delete m_rawNumericEventTable[i];
				m_rawNumericEventTable[i] = 0;
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Lookup functions
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int KviEventManager::lookupEventByName(const QString & n)
{
	for(int i = 0;i < KVI_NUM_SCRIPT_EVENTS;i++)
	{
		if(KviQString::equalCI(m_eventTable[i].szName,n))return i;
	}
	return -1;
}

KviScriptEventHandler * KviEventManager::lookupScriptEventHandler(int evIdx,const QString & hndName)
{
	if(!m_eventTable[evIdx].handlers)return 0;

	for(KviEventHandler * s = m_eventTable[evIdx].handlers->first();s;s = m_eventTable[evIdx].handlers->next())
	{
		if(s->type() == KviEventHandler::Script)
		{
			if(KviQString::equalCI(hndName,((KviScriptEventHandler *)s)->name()))return (KviScriptEventHandler *)s;
		}
	}
	return 0;
}

KviScriptEventHandler * KviEventManager::lookupRawNumericScriptEventHandler(int evIdx,const QString & hndName)
{
	if(!m_rawNumericEventTable[evIdx])return 0;

	for(KviEventHandler * s = m_rawNumericEventTable[evIdx]->first();s;s = m_rawNumericEventTable[evIdx]->next())
	{
		if(s->type() == KviEventHandler::Script)
		{
			if(KviQString::equalCI(hndName,((KviScriptEventHandler *)s)->name()))return (KviScriptEventHandler *)s;
		}
	}
	return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Code lookup functions
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

QString KviEventManager::lookupScriptHandlerCode(const QString & evName,const QString & hndName)
{
	int idx = lookupEventByName(evName);
	if(idx < 0)return QString::null;
	KviScriptEventHandler * s = lookupScriptEventHandler(idx,hndName);
	if(!s)return QString::null;
	return s->code();
}

QString KviEventManager::lookupRawNumericScriptHandlerCode(int idx,const QString & hndName)
{
	KviScriptEventHandler * s = lookupRawNumericScriptEventHandler(idx,hndName);
	if(!s)return QString::null;
	return s->code();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Registration functions for plain script handlers
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool KviEventManager::registerScriptHandler(const QString & evName,const QString & hndName,const QString & code,bool bEnabled)
{
	int idx = lookupEventByName(evName);
	if(idx < 0)return false;
	KviScriptEventHandler * s = lookupScriptEventHandler(idx,hndName);
	if(!s)
	{
		s = new KviScriptEventHandler();
		if(!m_eventTable[idx].handlers)
		{
			m_eventTable[idx].handlers = new KviEventHandlerList;
			m_eventTable[idx].handlers->setAutoDelete(true);
		}
		m_eventTable[idx].handlers->append(s);
		s->setName(hndName);
	}
	s->setEnabled(bEnabled);
	s->setCode(code);
	return true;
}

bool KviEventManager::unregisterScriptHandler(const QString & evName,const QString & hndName)
{
	int idx = lookupEventByName(evName);
	if(idx < 0)return false;
	if(!m_eventTable[idx].handlers)return false;
	for(KviEventHandler * s = m_eventTable[idx].handlers->first();s;s = m_eventTable[idx].handlers->next())
	{
		if(s->type() == KviEventHandler::Script)
		{
			if(KviQString::equalCI(hndName,((KviScriptEventHandler *)s)->name()))
			{
				m_eventTable[idx].handlers->removeRef(s);
				if(m_eventTable[idx].handlers->isEmpty())
				{
					delete m_eventTable[idx].handlers;
					m_eventTable[idx].handlers = 0;
					return true;
				}
			}
		}
	}
	return false;
}

bool KviEventManager::enableScriptHandler(const QString & evName,const QString & hndName,bool bEnable)
{
	int idx = lookupEventByName(evName);
	if(idx < 0)return false;
	KviScriptEventHandler * s = lookupScriptEventHandler(idx,hndName);
	if(s)
	{
		s->setEnabled(bEnable);
		return true;
	}
	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Registration functions for raw numeric script handlers
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool KviEventManager::registerRawNumericScriptHandler(int idx,const QString & hndName,const QString & code,bool bEnabled)
{
	KviScriptEventHandler * s = lookupRawNumericScriptEventHandler(idx,hndName);
	if(!s)
	{
		s = new KviScriptEventHandler();
		if(!m_rawNumericEventTable[idx])
		{
			m_rawNumericEventTable[idx] = new KviEventHandlerList;
			m_rawNumericEventTable[idx]->setAutoDelete(true);
		}
		m_rawNumericEventTable[idx]->append(s);
		s->setName(hndName);
	}
	s->setEnabled(bEnabled);
	s->setCode(code);
	return true;
}

bool KviEventManager::unregisterRawNumericScriptHandler(int idx,const QString & hndName)
{
	if(!m_rawNumericEventTable[idx])return false;
	for(KviEventHandler * s = m_rawNumericEventTable[idx]->first();s;s = m_rawNumericEventTable[idx]->next())
	{
		if(s->type() == KviEventHandler::Script)
		{
			if(kvi_strEqualCI(((KviScriptEventHandler *)s)->name(),hndName))
			{
				m_rawNumericEventTable[idx]->removeRef(s);
				if(m_rawNumericEventTable[idx]->isEmpty())
				{
					delete m_rawNumericEventTable[idx];
					m_rawNumericEventTable[idx] = 0;
					return true;
				}
			}
		}
	}
	return false;
}

bool KviEventManager::enableRawNumericScriptHandler(int idx,const QString & hndName,bool bEnable)
{
	KviScriptEventHandler * s = lookupRawNumericScriptEventHandler(idx,hndName);
	if(s)
	{
		s->setEnabled(bEnable);
		return true;
	}
	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Registration functions for plain module handlers
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void KviEventManager::registerModuleHandler(int evIdx,KviModuleEventHandler * h)
{
	unregisterModuleHandler(evIdx,h->module());
	if(!m_eventTable[evIdx].handlers)
	{
		m_eventTable[evIdx].handlers = new KviEventHandlerList;
		m_eventTable[evIdx].handlers->setAutoDelete(true);
	}
	m_eventTable[evIdx].handlers->append(h);
}

void KviEventManager::unregisterModuleHandler(int evIdx,KviModule * m)
{
	if(!m_eventTable[evIdx].handlers)return;
	for(KviEventHandler * e = m_eventTable[evIdx].handlers->first();e;e = m_eventTable[evIdx].handlers->next())
	{
		if(e->type() == KviEventHandler::Module)
		{
			if(((KviModuleEventHandler *)e)->module() == m)
			{
				m_eventTable[evIdx].handlers->removeRef(e);
				if(m_eventTable[evIdx].handlers->isEmpty())
				{
					delete m_eventTable[evIdx].handlers;
					m_eventTable[evIdx].handlers = 0;
				}
				return;
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Registration functions for raw numeric module handlers
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void KviEventManager::registerRawNumericModuleHandler(int evIdx,KviModuleEventHandler * h)
{
	unregisterRawNumericModuleHandler(evIdx,h->module());
	if(!m_rawNumericEventTable[evIdx])
	{
		m_rawNumericEventTable[evIdx] = new KviEventHandlerList;
		m_rawNumericEventTable[evIdx]->setAutoDelete(true);
	}
	m_rawNumericEventTable[evIdx]->append(h);
}

void KviEventManager::unregisterRawNumericModuleHandler(int evIdx,KviModule * m)
{
	if(!m_rawNumericEventTable[evIdx])return;
	for(KviEventHandler * e = m_rawNumericEventTable[evIdx]->first();e;e = m_rawNumericEventTable[evIdx]->next())
	{
		if(e->type() == KviEventHandler::Module)
		{
			if(((KviModuleEventHandler *)e)->module() == m)
			{
				m_rawNumericEventTable[evIdx]->removeRef(e);
				if(m_rawNumericEventTable[evIdx]->isEmpty())
				{
					delete m_rawNumericEventTable[evIdx];
					m_rawNumericEventTable[evIdx] = 0;
				}
				return;
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Registration functions for all module handlers
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void KviEventManager::unregisterAllModuleHandlers(KviModule * m)
{
	int i;
	for(i=0;i<KVI_NUM_SCRIPT_EVENTS;i++)unregisterModuleHandler(i,m);
	for(i=0;i<1000;i++)unregisterRawNumericModuleHandler(i,m);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Load & save
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void KviEventManager::saveRaw(const QString & filename)
{
	KviConfig cfg(filename,KviConfig::Write);
	cfg.clear();
	int i;

	for(i=0;i<1000;i++)
	{
		if(m_rawNumericEventTable[i])
		{
			KviStr tmp(KviStr::Format,"RAW%d",i);
			cfg.setGroup(tmp.ptr());
			int index = 0;
			for(KviEventHandler* s = m_rawNumericEventTable[i]->first();s; s = m_rawNumericEventTable[i]->next())
			{
				if(s->type() == KviEventHandler::Script)
				{
					KviStr tmp(KviStr::Format,"Name%d",index);
					cfg.writeEntry(tmp.ptr(),((KviScriptEventHandler *)s)->name());
					tmp.sprintf("Buffer%d",index);
					cfg.writeEntry(tmp.ptr(),((KviScriptEventHandler *)s)->code());
					tmp.sprintf("Enabled%d",index);
					cfg.writeEntry(tmp.ptr(),((KviScriptEventHandler *)s)->enabled());
					index++;
				}
			}
			cfg.writeEntry("NHandlers",index);
		}
	}
}

void KviEventManager::loadRaw(const QString & filename)
{
	KviConfig cfg(filename,KviConfig::Read);
	clearRawScriptHandlers();
	int i;


	for(i=0;i<1000;i++)
	{
		KviStr tmp(KviStr::Format,"RAW%d",i);
		if(cfg.hasGroup(tmp.ptr()))
		{
			cfg.setGroup(tmp.ptr());
			unsigned int nHandlers = cfg.readUIntEntry("NHandlers",0);
			if(nHandlers)
			{
				m_rawNumericEventTable[i] = new KviEventHandlerList;
				m_rawNumericEventTable[i]->setAutoDelete(true);
				for(unsigned int index = 0;index < nHandlers;index++)
				{
					KviStr tmp(KviStr::Format,"Name%u",index);
					KviScriptEventHandler *s = new KviScriptEventHandler();
					s->setName(cfg.readEntry(tmp.ptr(),"unnamed"));
					tmp.sprintf("Buffer%u",index);
					s->setCode(cfg.readEntry(tmp.ptr(),""));
					tmp.sprintf("Enabled%u",index);
					s->setEnabled(cfg.readBoolEntry(tmp.ptr(),false));
					m_rawNumericEventTable[i]->append(s);
				}
			}
		}
	}
}

void KviEventManager::save(const QString & filename)
{
	KviConfig cfg(filename,KviConfig::Write);
	cfg.clear();
	int i;

	for(i=0;i<KVI_NUM_SCRIPT_EVENTS;i++)
	{
		if(m_eventTable[i].handlers)
		{
			cfg.setGroup(m_eventTable[i].szName);
			int index = 0;
			for(KviEventHandler* s = m_eventTable[i].handlers->first();s; s = m_eventTable[i].handlers->next())
			{
				if(s->type() == KviEventHandler::Script)
				{
					KviStr tmp(KviStr::Format,"Name%d",index);
					cfg.writeEntry(tmp.ptr(),((KviScriptEventHandler *)s)->name());
					tmp.sprintf("Buffer%d",index);
					cfg.writeEntry(tmp.ptr(),((KviScriptEventHandler *)s)->code());
					tmp.sprintf("Enabled%d",index);
					cfg.writeEntry(tmp.ptr(),((KviScriptEventHandler *)s)->enabled());
					index++;
				}
			}
			cfg.writeEntry("NHandlers",index);
		}
	}
}


void KviEventManager::load(const QString & filename)
{
	KviConfig cfg(filename,KviConfig::Read);
	clearScriptHandlers();
	int i;
	for(i=0;i<KVI_NUM_SCRIPT_EVENTS;i++)
	{
		//debug("Loading event %d",i);
		if(cfg.hasGroup(m_eventTable[i].szName))
		{
			//debug("Is there");
			cfg.setGroup(m_eventTable[i].szName);
			unsigned int nHandlers = cfg.readUIntEntry("NHandlers",0);
			if(nHandlers)
			{
				//debug("nHandlers is %d",nHandlers);
				m_eventTable[i].handlers = new KviEventHandlerList;
				m_eventTable[i].handlers->setAutoDelete(true);

				for(unsigned int index = 0;index < nHandlers;index++)
				{
					//debug("Loading it");
					KviStr tmp(KviStr::Format,"Name%u",index);
					KviScriptEventHandler *s = new KviScriptEventHandler();
					s->setName(cfg.readEntry(tmp.ptr(),"unnamed"));
					tmp.sprintf("Buffer%u",index);
					s->setCode(cfg.readEntry(tmp.ptr(),""));
					tmp.sprintf("Enabled%u",index);
					s->setEnabled(cfg.readBoolEntry(tmp.ptr(),false));
					m_eventTable[i].handlers->append(s);
				}
			}
		}
	}
}

*/
