#ifndef _KVI_EVENT_H_
#define _KVI_EVENT_H_

//
//   File : kvi_event.h
//   Creation date : Thu Aug 17 2000 13:59:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

/*
#include "kvi_settings.h"

#include "kvi_string.h"
#include "kvi_list.h"
#include <qasciidict.h>

#include "kvi_kvs_eventtable.h"

// FIXME: #warning "Query user list clicks"
// FIXME: #warning "Notify list clicks"
// FIXME: #warning "Dcc user list clicks (other user list clicks)"
// FIXME: #warning "OnIdle : when the user stops to type on the keyboard"



class KviModule;
class KviEventHandler;
class KviScriptEventHandler;
class KviModuleEventHandler;

typedef KviPtrList<KviEventHandler> KviEventHandlerList;

class KVIRC_API KviEventStruct
{
public:
	QString               szName;
	QString               szParams;
	KviEventHandlerList * handlers;
public:
	KviEventStruct(const char *n,const char *p,KviEventHandlerList * l)
		: szName(n), szParams(p),handlers(l) {};
};


class KVIRC_API KviEventManager
{
	friend class KviUserParser;
	friend class KviModule;
public:
	KviEventManager();
	~KviEventManager();
protected:
	static KviEventStruct   m_eventTable[KVI_NUM_SCRIPT_EVENTS];
	KviEventHandlerList   * m_rawNumericEventTable[1000];
public:
	void load(const QString & filename);
	void save(const QString & filename);

	void loadRaw(const QString & filename);
	void saveRaw(const QString & filename);

	void clear();
	void clearScriptHandlers();
	void clearRawScriptHandlers();

	const QString & eventName(int index){ return m_eventTable[index].szName; };
	const QString & eventParams(int index){ return m_eventTable[index].szParams; };

	bool hasEventHandlers(int index){ return (m_eventTable[index].handlers); };
	bool hasRawEventHandlers(int index){ return (m_rawNumericEventTable[index]); };
	// unused ?
	KviEventHandlerList * handlers(int index){ return m_eventTable[index].handlers; };
	KviEventHandlerList * rawNumericHandlers(int index){ return m_rawNumericEventTable[index]; };

	bool registerScriptHandler(const QString & evName,const QString & hndName,const QString & code,bool bEnabled = true);
	bool unregisterScriptHandler(const QString & evName,const QString & hndName);
	bool enableScriptHandler(const QString & evName,const QString & hndName,bool bEnable);
	QString lookupScriptHandlerCode(const QString & evName,const QString & hndName);

	bool registerRawNumericScriptHandler(int idx,const QString & hndName,const QString & code,bool bEnabled = true);
	bool unregisterRawNumericScriptHandler(int idx,const QString & hndName);
	bool enableRawNumericScriptHandler(int idx,const QString & hndName,bool bEnable);
	QString lookupRawNumericScriptHandlerCode(int idx,const QString & hndName);

protected: // KviModule
	void registerModuleHandler(int evIdx,KviModuleEventHandler * h);
	void unregisterModuleHandler(int evIdx,KviModule * m);
	void registerRawNumericModuleHandler(int evIdx,KviModuleEventHandler * h);
	void unregisterRawNumericModuleHandler(int evIdx,KviModule * m);
	void unregisterAllModuleHandlers(KviModule * m);
protected:

	void clearScriptHandlers(KviEventHandlerList * l);

	int lookupEventByName(const QString & n);

	KviScriptEventHandler * lookupScriptEventHandler(int evIdx,const QString & hndName);
	KviScriptEventHandler * lookupRawNumericScriptEventHandler(int evIdx,const QString & hndName);
};

extern KVIRC_API KviEventManager * g_pEventManager;

#ifndef _KVI_EVENT_CPP_

*/

#include "kvi_uparser.h"
#include "kvi_kvs_eventmanager.h"

// This is a quick macro... can't propagate the return value..so it is useless when we
// have to handle the 'halt' command

#define TRIGGER_EVENT(__idx,__wnd) \
	if(KviKvsEventManager::instance()->hasAppHandlers(__idx))g_pUserParser->triggerEvent(__idx,__wnd,0)

// This one propagates the return value of triggerEvent (returns TRUE if halt was called!)

#define TRIGGER_EVENT_RETVALUE(__idx,__wnd) \
	(KviKvsEventManager::instance()->hasAppHandlers(__idx) ? g_pUserParser->triggerEvent(__idx,__wnd,0) : false)


#define TRIGGER_EVENT_1PARAM(__idx,__wnd,__p1) \
	if(KviKvsEventManager::instance()->hasAppHandlers(__idx))g_pUserParser->triggerEvent(__idx,__wnd, \
		new KviParameterList(new KviStr(__p1)))

#define TRIGGER_EVENT_1PARAM_NONEW(__idx,__wnd,__p1) \
	if(KviKvsEventManager::instance()->hasAppHandlers(__idx))g_pUserParser->triggerEvent(__idx,__wnd, \
		new KviParameterList(__p1))

#define TRIGGER_EVENT_1PARAM_RETVALUE(__idx,__wnd,__param) \
	(KviKvsEventManager::instance()->hasAppHandlers(__idx) ? \
		g_pUserParser->triggerEvent(__idx,__wnd,new KviParameterList(new KviStr(__param))) : false)

#define TRIGGER_EVENT_2PARAM(__idx,__wnd,__p1,__p2) \
	if(KviKvsEventManager::instance()->hasAppHandlers(__idx)) \
		g_pUserParser->triggerEvent(__idx,__wnd, \
			new KviParameterList(new KviStr(__p1),new KviStr(__p2)))

#define TRIGGER_EVENT_2PARAM_RETVALUE(__idx,__wnd,__p1,__p2) \
	(KviKvsEventManager::instance()->hasAppHandlers(__idx) ? \
		g_pUserParser->triggerEvent(__idx,__wnd, \
			new KviParameterList(new KviStr(__p1),new KviStr(__p2))) : \
		false)

#define TRIGGER_EVENT_3PARAM(__idx,__wnd,__p1,__p2,__p3) \
	if(KviKvsEventManager::instance()->hasAppHandlers(__idx))g_pUserParser->triggerEvent(__idx,__wnd, \
		new KviParameterList(new KviStr(__p1),new KviStr(__p2),new KviStr(__p3)))


#define TRIGGER_EVENT_3PARAM_RETVALUE(__idx,__wnd,__p1,__p2,__p3) \
	(KviKvsEventManager::instance()->hasAppHandlers(__idx) ? \
		g_pUserParser->triggerEvent(__idx,__wnd, \
			new KviParameterList(new KviStr(__p1),new KviStr(__p2),new KviStr(__p3))) : \
		false)

#define TRIGGER_EVENT_4PARAM_RETVALUE(__idx,__wnd,__p1,__p2,__p3,__p4) \
	(KviKvsEventManager::instance()->hasAppHandlers(__idx) ? \
		g_pUserParser->triggerEvent(__idx,__wnd, \
			new KviParameterList(new KviStr(__p1),new KviStr(__p2), \
				new KviStr(__p3),new KviStr(__p4))) : \
		false)

#define TRIGGER_EVENT_5PARAM_RETVALUE(__idx,__wnd,__p1,__p2,__p3,__p4,__p5) \
	(KviKvsEventManager::instance()->hasAppHandlers(__idx) ? \
		g_pUserParser->triggerEvent(__idx,__wnd, \
			new KviParameterList(new KviStr(__p1),new KviStr(__p2), \
				new KviStr(__p3),new KviStr(__p4),new KviStr(__p5))) : \
		false)

#define TRIGGER_EVENT_6PARAM_RETVALUE(__idx,__wnd,__p1,__p2,__p3,__p4,__p5,__p6) \
	(KviKvsEventManager::instance()->hasAppHandlers(__idx) ? \
		g_pUserParser->triggerEvent(__idx,__wnd, \
			new KviParameterList(new KviStr(__p1),new KviStr(__p2), \
				new KviStr(__p3),new KviStr(__p4),new KviStr(__p5),new KviStr(__p6))) : \
		false)

#define TRIGGER_EVENT_7PARAM_RETVALUE(__idx,__wnd,__p1,__p2,__p3,__p4,__p5,__p6,__p7) \
	(KviKvsEventManager::instance()->hasAppHandlers(__idx) ? \
		g_pUserParser->triggerEvent(__idx,__wnd, \
			new KviParameterList(new KviStr(__p1),new KviStr(__p2), \
				new KviStr(__p3),new KviStr(__p4),new KviStr(__p5), \
				new KviStr(__p6),new KviStr(__p7))) : \
		false)


/*
#endif
*/


#endif //_KVI_EVENT_H_
