#ifndef _KVI_POPUPMANAGER_H_
#define _KVI_POPUPMANAGER_H_

//=============================================================================
//
//   File : kvi_popupmanager.h
//   Creation date : Sun Sep 1 2000 16:13:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"

#include "kvi_popupmenu.h"
#include <qdict.h>
#include "kvi_list.h"
#include "kvi_string.h"

class KVIRC_API KviPopupManager
{
public:
	KviPopupManager();
	~KviPopupManager();
private:
	QDict<KviPopupMenu> * m_pPopupDict;
public:
	//void killPopupsInList(KviPtrList<KviStr> * l);
	void clear(){ m_pPopupDict->clear(); };
	int popupCount(){ return m_pPopupDict->count(); };
	const QDict<KviPopupMenu> * popupDict(){ return m_pPopupDict; };
	KviPopupMenu * lookupPopup(const QString &nam){ return m_pPopupDict->find(nam); };
	KviPopupMenu * getPopup(const QString &nam);
	void removePopup(const QString &nam){ m_pPopupDict->remove(nam); };
	void save(const QString & filename);
	void load(const QString & filename);
};

extern KVIRC_API KviPopupManager * g_pPopupManager;

#endif //_KVI_POPUPMANAGER_H_
