#ifndef _KVI_POPUPMENU_H_
#define _KVI_POPUPMENU_H_

//=============================================================================
//
//   File : kvi_popupmenu.h
//   Creation date : Sun Sep 1 2000 14:47:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2003 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_string.h"
#include "kvi_heapobject.h"

#include <qpopupmenu.h>
#include "kvi_list.h"

class KviPopupMenuItem;

class KviWindow;
class KviParameterList;
class KviDataContainer;
class KviConfig;

class QLabel;

class KVIRC_API KviPopupMenuTopLevelData : public KviHeapObject
{
	friend class KviPopupMenu;
public:
	KviPopupMenuTopLevelData(KviDataContainer * d,KviParameterList * l,KviWindow * wnd,bool bRunInTestMode = false);
	~KviPopupMenuTopLevelData();
protected:
	KviParameterList * pParamList;
	KviDataContainer * pDataContainer;
	KviWindow        * pWnd;
	bool               bLocked;
	bool               bTestMode;         // are we running in test mode ?
};

class KVIRC_API KviPopupMenuCodeSnippet
{
public:
	QString m_szCode;
	QString m_szId;
};

class KVIRC_API KviPopupMenu : public QPopupMenu, public KviHeapObject
{
	friend class KviPopupManager;
	friend class KviSinglePopupEditor;
	Q_OBJECT
public:
	KviPopupMenu(const QString &name);
	~KviPopupMenu();
protected:
	KviPtrList<KviPopupMenuItem>  * m_pItemList;
private:
	KviPopupMenu                  * m_pParentPopup;
	KviPtrList<KviPopupMenuCodeSnippet>           * m_pPrologues;
	KviPtrList<KviPopupMenuCodeSnippet>           * m_pEpilogues;
	KviPopupMenuTopLevelData      * m_pTopLevelData;
	// this is a temporary used to hack-in the activation from KviMenuBar
	KviPopupMenuTopLevelData      * m_pTempTopLevelData;
	bool                            m_bSetupDone;
public:
	void copyFrom(const KviPopupMenu * src);
	KviPopupMenuTopLevelData * topLevelData();
	KviPopupMenu * topLevelPopup();
	bool isLocked();
	bool removeItemById(const QString &szId,bool bRecursive);
	void addItem(KviPopupMenuItem * it);
	void doPopup(const QPoint & pnt,KviWindow * wnd,KviParameterList * params,bool bTestMode = false);
	bool isEmpty(){ return m_pItemList->isEmpty() && m_pPrologues->isEmpty() && m_pEpilogues->isEmpty(); };
	void doClear();
	void addPrologue(KviPopupMenuCodeSnippet * s){ m_pPrologues->append(s); };
	void addEpilogue(KviPopupMenuCodeSnippet * s){ m_pEpilogues->append(s); };
	KviPtrList<KviPopupMenuCodeSnippet> * epilogues(){ return m_pEpilogues; };
	KviPtrList<KviPopupMenuCodeSnippet> * prologues(){ return m_pPrologues; };
	KviPopupMenu * parentPopup(){ return m_pParentPopup; };
	void generateDefPopup(QString &buffer);
protected:
	void lock(bool bLock);
	void setParentPopup(KviPopupMenu * par){ m_pParentPopup = par; };
	void load(const QString &prefix,KviConfig * cfg);
	void save(const QString &prefix,KviConfig * cfg);
	void generateDefPopupCore(QString &buffer);
	void testModeItemClickedInternal(KviPopupMenuItem * it); // it may be also a child subpopup's item!
private slots:
	void setupMenuContents();
private:
	void clearMenuContents();
protected slots:
	void itemClicked(int itemId);
signals:
	void testModeItemClicked(KviPopupMenuItem * it);
};


class KVIRC_API KviPopupMenuItem : public KviHeapObject
{
public:
	enum Type { Item , Menu , Label , Separator , ExtMenu };
private:
	Type           m_type;
	QString        m_szText;
	QString        m_szCode; // for "ExtMenu" it contains the external menu name!!!!!!!
	QString        m_szIcon;
	QString        m_szExpr;
	KviPopupMenu * m_pMenu;
	QLabel       * m_pLabel;
	QString        m_szId;   // id, if specified
public:
	KviPopupMenuItem(Type t,
		const QString &text = QString::null,
		const QString &icon = QString::null,
		const QString &expr = QString::null,
		const QString &code = QString::null,
		KviPopupMenu * menu = 0,
		const QString &id = QString::null)
			: m_type(t),
			m_szText(text),
			m_szCode(code),
			m_szIcon(icon),
			m_szExpr(expr),
			m_pMenu(menu),
			m_pLabel(0),
			m_szId(id) {};

	KviPopupMenuItem(const KviPopupMenuItem *src);
	~KviPopupMenuItem(){ if(m_pMenu)delete m_pMenu; };
public:
	KviPopupMenuItem::Type type(){ return m_type; };

	const QString &text(){ return m_szText; };
	const QString &code(){ return m_szCode; };
	const QString &icon(){ return m_szIcon; };
	const QString &expr(){ return m_szExpr; };
	const QString &id(){ return m_szId; };

	bool hasExpression(){ return !m_szExpr.isEmpty(); };
	bool hasIcon(){ return !m_szIcon.isEmpty(); };

	bool isSeparator(){ return m_type == Separator; };
	bool isLabel(){ return m_type == Label; };
	bool isExtMenu(){ return m_type == ExtMenu; };
	bool isMenu(){ return m_type == Menu; };

	QLabel * label(){ return m_pLabel; };
	void setLabel(QLabel * l){ m_pLabel = l; };

	KviPopupMenu * menu(){ return m_pMenu; };
	void setMenu(KviPopupMenu * m);
};


#endif //_KVI_POPUPMENU_H_
