#ifndef _KVI_PROCESSMANAGER_H_
#define _KVI_PROCESSMANAGER_H_
//=============================================================================
//
//   File : kvi_processmanager.h
//   Created on Wed 07 Apr 2004 03:03:52 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"

#include "kvi_qstring.h"
#include "kvi_string.h"
#include "kvi_datacontainer.h"
#include "kvi_window.h"

#include <qptrdict.h>

#ifdef Unsorted
	#undef Unsorted
#endif

#include <qprocess.h>
#include <qtimer.h>

#define KVI_PROCESSDESCRIPTOR_TRIGGERSTDOUT 1
#define KVI_PROCESSDESCRIPTOR_TRIGGERSTDERR 2
#define KVI_PROCESSDESCRIPTOR_TRIGGERTERMINATED 4
#define KVI_PROCESSDESCRIPTOR_OUTPUTBYBLOCKS 8
#define KVI_PROCESSDESCRIPTOR_TRIGGERSTARTED 16
#define KVI_PROCESSDESCRIPTOR_NOSHELL 32
#define KVI_PROCESSDESCRIPTOR_KILLIFNOWINDOW 64


typedef struct _KviProcessDescriptorData
{
	QString     szShell;
	QString     szCommandline;
	KviStr      szCallback;
	KviStr      szMagic;
	int         iFlags;
	KviWindow * pWnd;
	int         iMaxRunTime;  // 0 for no timeout
	int         iPingTimeout; // 0 for no ping timeout
} KviProcessDescriptorData;

class KviProcessManager;

class KVIRC_API KviProcessDescriptor : public QObject
{
	friend class KviProcessManager;
	Q_OBJECT
public:
	KviProcessDescriptor(KviProcessDescriptorData * d,KviProcessManager * pManager);
	~KviProcessDescriptor();
protected:
	enum CallbackEvent { EventStarted,EventTerminated,EventStdout,EventStderr,EventPing };
private:
	QProcess                 * m_pProcess;
	KviDataContainer         * m_pDataContainer;
	QString                    m_szStdoutBuffer;
	QString                    m_szStderrBuffer;
	KviProcessDescriptorData * m_pData;
	QTimer                   * m_pPingTimer;
	QTimer                   * m_pRunTimeTimer;
	bool                       m_bDeletePending;
protected:
	bool start();
private slots:
	void maxRunTimeExpired();
	void ping();
	void readStdout();
	void readStderr();
	void processExited();
	void selfDelete();
private:
	bool trigger(CallbackEvent e,const QString &szData);
	void triggerSelfDelete();
};




class KVIRC_API KviProcessManager : public QObject
{
	friend class KviApp; // for init() and done()
	Q_OBJECT
protected:
	KviProcessManager();
	~KviProcessManager();
protected:
	static KviProcessManager             * m_pInstance;
public:
	static KviProcessManager * instance(){ return m_pInstance; };
	// this object takes the ownership of the descriptor
	bool execute(KviProcessDescriptorData * d);
protected:
	// KviApp only
	static void init();
	static void done();
};

#endif //!_KVI_PROCESSMANAGER_H_
