//
//   File : kvi_timermanager.cpp
//   Creation date : Wed Aug 29 15:33:29 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define __KVIRC__
#include "kvi_timermanager.h"

#include "kvi_app.h"
#include "kvi_parameterlist.h"
#include "kvi_frame.h"
#include "kvi_window.h"
#include "kvi_uparser.h"
#include "kvi_ircview.h"
#include "kvi_locale.h"
#include "kvi_out.h"
#include "kvi_console.h"
#include "kvi_mirccntrl.h"
#include "kvi_options.h"
#include "kvi_command.h"
#include "kvi_datacontainer.h"

KviUserTimer::KviUserTimer()
{
	m_pDataContainer = new KviDataContainer(false);
}

KviUserTimer::~KviUserTimer()
{
	if(m_pParams)delete m_pParams;
	delete m_pDataContainer;
}



KviTimerManager::KviTimerManager()
{
	m_pTimerDict = new QIntDict<KviUserTimer>;
	m_pTimerDict->setAutoDelete(false);
	m_pAsciiTimerDict = new QAsciiDict<KviUserTimer>;
	m_pAsciiTimerDict->setAutoDelete(true);
	tickTimer = startTimer(1000); // every second
}

KviTimerManager::~KviTimerManager()
{
	killTimers();
	delete m_pTimerDict;
	delete m_pAsciiTimerDict;
}

bool KviTimerManager::isTimer(const char * name)
{
	return (m_pAsciiTimerDict->find(name) != 0);
}

bool KviTimerManager::addTimer(KviStr & name,KviWindow * pWnd,KviStr &szCmd,KviParameterList * params,int iDelay,unsigned int uFlags)
{
	KviUserTimer * t = new KviUserTimer();
	t->m_szName = name;
	t->m_pWnd = pWnd;
	t->m_szCmd = szCmd;
	t->m_pParams = params;
	t->m_iDelay = iDelay;
	t->m_uFlags = uFlags;
	int id = startTimer(t->m_iDelay);
	if(id > 0)
	{
		t->m_iId = id;
		if(KviUserTimer * old = m_pAsciiTimerDict->find(name.ptr()))
		{
			killTimer(old->m_iId);
			m_pTimerDict->remove(old->m_iId);
			m_pAsciiTimerDict->remove(name.ptr());
		}
		m_pAsciiTimerDict->insert(name.ptr(),t);
		m_pTimerDict->insert(id,t);
	} else {
		delete t;
		return false;
	}
	return true;
}

bool KviTimerManager::delTimer(const char * name)
{
	KviUserTimer * t = m_pAsciiTimerDict->find(name);
	if(!t)return false;
	killTimer(t->m_iId);
	m_pTimerDict->remove(t->m_iId);
	m_pAsciiTimerDict->remove(name);
	return true;
}

void KviTimerManager::timerEvent(QTimerEvent *e)
{
     int id = e->timerId();
//#warning "Move this to a more appropriate place... maybe a global KviApp::heartbeat() ? More things could go in there too"

	// What the heck is this ?
	// this is supposed to restart logging
	// in order to rotate the log files
	if (id == tickTimer)
	{
		//if (!QTime::currentTime().secsTo(QTime(0,0,0)))
		time_t t = time(0);
		const struct tm * pTm = localtime(&t);

		if (!pTm->tm_hour && !pTm->tm_min && !pTm->tm_sec)
		{
			KviPtrList<KviWindow> * wList = g_pFrame->windowList();
			for (KviWindow * wnd = wList->first();wnd;wnd = wList->next())
				if (wnd->view() && wnd->view()->isLogging())
					wnd->view()->startLogging(0);
		}
		return;
	}

	KviUserTimer * t = m_pTimerDict->find(id);
	if(!t)
	{
		debug("Internal error: got an nonexistant timer event");
		return; // HUH ?
	}

	if(!g_pApp->windowExists(t->m_pWnd))
	{
		if(t->m_uFlags & KVI_USER_TIMER_FLAG_PERSISTENT)
		{
			t->m_pWnd = g_pApp->activeConsole();
		} else {
			delTimer(t->m_szName.ptr());
			return;
		}
	}

	// Copy the name , so we can remember it even after the timer was killed
	KviStr szTimerName = t->m_szName;
	KviWindow * pWnd = t->m_pWnd;

	KviCommand cmd(t->m_szCmd.ptr(),pWnd,0,t->m_pDataContainer);
	if(t->m_pParams)cmd.setParams(t->m_pParams,false);
	bool bResult = g_pUserParser->parseCommand(&cmd);
	cmd.forgetExtendedScopeDataContainer();

	if(!bResult)
	{
		if(cmd.hasError())
		{
			g_pUserParser->printError(&cmd);
		} else bResult = true; // just halt called
	}

	// Here the timer MAY already have been removed by /killtimer
	// Check it out...

	bool bRemoved = (t != m_pTimerDict->find(e->timerId()));

	if(!bResult)
	{
		pWnd->output(KVI_OUT_PARSERERROR,
			__tr2qs("Error triggered from timer callback handler %c'%s'"),KVI_TEXT_BOLD,szTimerName.ptr());

		if(!bRemoved && KVI_OPTION_BOOL(KviOption_boolKillBrokenTimers))
		{
			pWnd->output(KVI_OUT_PARSERERROR,__tr2qs("Timer callback handler '%s' is broken: killing"),szTimerName.ptr());
			delTimer(t->m_szName.ptr());
		}
	}

	if(bRemoved)return;

	if(t->m_uFlags & KVI_USER_TIMER_FLAG_SINGLE_SHOT)
	{
		delTimer(t->m_szName.ptr());
	}
}

#include "kvi_timermanager.moc"
