/*
    mp3tech.h - Headers for mp3tech.c

    Copyright (C) 2000  Cedric Tefft <cedric@earthling.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  ***************************************************************************

  This file is based in part on:

	* MP3Info 0.5 by Ricardo Cerqueira <rmc@rccn.net>
	* MP3Stat 0.9 by Ed Sweetman <safemode@voicenet.com> and 
			 Johannes Overmann <overmann@iname.com>

*/

/* MIN_CONSEC_GOOD_FRAMES defines how many consecutive valid MP3 frames
   we need to see before we decide we are looking at a real MP3 file */
#define MIN_CONSEC_GOOD_FRAMES 4
#define FRAME_HEADER_SIZE 4
#define MIN_FRAME_SIZE 21
#define NUM_SAMPLES 4
#define TEXT_FIELD_LEN	30
#define INT_FIELD_LEN	4

/*
    mp3info.h - Header files for MP3Info

    Copyright (C) 2000  Cedric Tefft <cedric@earthling.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  ***************************************************************************

  This program is based in part on MP3Info 0.5 by Ricardo Cerqueira <rmc@rccn.net>

*/

// this will just NOT compile on winzozz

#include "kvi_settings.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef COMPILE_ON_WINDOWS
	#include <windows.h>
#else
	#include <unistd.h>
	#include <sys/stat.h>
	#include <ctype.h>
	#include <string.h>
#endif

/*#include <curses.h>*/
/*#include <signal.h>*/
//#include "mp3tech.h"
/*#include "textfunc.h"*/


//#define VERSION "MP3Info 0.8.2"
//#define COPYRIGHT "Copyright (C) 2000 Cedric Tefft"








enum VBR_REPORT { VBR_VARIABLE, VBR_AVERAGE, VBR_MEDIAN };
enum SCANTYPE { SCAN_NONE, SCAN_QUICK, SCAN_FULL };

typedef struct {
	unsigned int	sync;
	unsigned int	version;
	unsigned int	layer;
	unsigned int	crc;
	unsigned int	bitrate;
	unsigned int	freq;
	unsigned int	padding;
	unsigned int	extension;
	unsigned int	mode;
	unsigned int	mode_extension;
	unsigned int	copyright;
	unsigned int	original;
	unsigned int	emphasis;
} mp3header;

typedef struct {
	char title[31];
	char artist[31];
	char album[31];
	char year[5];
	char comment[31];
	unsigned char track[1];
	unsigned char genre[1];
} id3tag;

typedef struct {
	char *filename;
	FILE *file;
	unsigned int datasize;
	int header_isvalid;
	mp3header header;
	int id3_isvalid;
	id3tag id3;
	int vbr;
	float vbr_average;
	int seconds;
	int frames;
	int badframes;
} mp3info;


int header_frequency(mp3header *h);
const char *header_emphasis(mp3header *h);
const char *header_mode(mp3header *h);
int header_layer(mp3header *h);
int header_bitrate(mp3header *h);
double header_version(mp3header *h);
int header_crc(mp3header *h);

int get_header(FILE *file,mp3header *header);
int frame_length(mp3header *header);
int sameConstant(mp3header *h1, mp3header *h2);
int get_mp3_info(mp3info *mp3,int scantype, int fullscan_vbr);
int get_id3(mp3info *mp3);
char *pad(char *string, int length);
char *unpad(char *string);
int write_tag(mp3info *mp3);
int get_first_header(mp3info *mp3,long startpos);
int get_next_header(mp3info *mp3);
void tagedit_curs(char *filename, int filenum, int fileoutof, id3tag *tag);
const char * get_typegenre(int idx);

//extern char *typegenre [MAXGENRE+2];
/*
extern int alphagenreindex [MAXGENRE+1];
extern int galphagenreindex [MAXGENRE+2];
*/

