#ifndef	_CLASS_COMBOBOX_H_
#define	_CLASS_COMBOBOX_H_

//vim: ts=8
//   File : class_combobox.h
//   Creation date : Thu Mar 22 20:57:28 CET 2001 by Krzysztof Godlewski
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include <qcombobox.h>
#include "class_widget.h"

//#warning "Signals !"

class KviScriptComboBoxObject : public KviScriptWidgetObject
{
	Q_OBJECT
public:
	KviScriptComboBoxObject(KviScriptObjectClass *, KviScriptObject *, \
		const char *);
	~KviScriptComboBoxObject();

	static void registerSelf();
	static void unregisterSelf();
	
protected:
	virtual bool init(KviCommand *);

	bool functionInsertList(KviCommand *, KviParameterList *, KviStr &);
	bool functionInsertItem(KviCommand *, KviParameterList *, KviStr &);
	bool functionChangeItem(KviCommand *, KviParameterList *, KviStr &);
	bool functionRemoveItem(KviCommand *, KviParameterList *, KviStr &);
//#warning "$insertPixItem"
//#warning "$changePixItem"

	bool functionCount(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetMaxCount(KviCommand *, KviParameterList *, KviStr &);
	bool functionMaxCount(KviCommand *, KviParameterList *, KviStr &);
	bool functionCurrent(KviCommand *, KviParameterList *, KviStr &);
	bool functionCurrentIndex(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetEditable(KviCommand *, KviParameterList *, KviStr &);
	bool functionEditable(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetEditText(KviCommand *, KviParameterList *, KviStr &);
	bool functionTextAt(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetCurrentItem(KviCommand *, KviParameterList *, KviStr &);
};

#endif	// !_CLASS_COMBOBOX_H_
