//
//   File : class_grupbox.cpp
//   Creation date : Fri Jan 28 14:21:48 CEST 2005 
//   by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
// 
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2005 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qgroupbox.h>
#include "class_groupbox.h"
#include "kvi_error.h"
#include "kvi_debug.h"
#include "kvi_command.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"

// Tables used in $setAlignment , $alignment and in $setOrientation & $orientation

const char * const align_tbl[] = {
			"Left", 
			"Right",
			"HCenter"
			   };
const int align_cod[] = {
		Qt::AlignLeft,
		Qt::AlignRight,
		Qt::AlignHCenter
			};
#define align_num	(sizeof(align_tbl) / sizeof(align_tbl[0]))


/*
	@doc:	grupbox
	@keyterms:
		grupbox object class,
	@title:
		grupbox class
	@type:
		class
	@short:
		Provides a groupbox bar.
	@inherits:
		[class]object[/class]
		[class]widget[/class]
	@description:
		This widget can be used to display a groupbox.
	@functions:
		!fn: $setTitle(<text>)
		Sets the group box title to <text>.[br]
		!fn: $title()
		Returns the group box title text.[br]
		!fn: $isFlat(<bool>)
		Sets whether the group box is painted flat. Valid Values are 1 or 0.[br]
		!fn: $isCheckable()
		Returns TRUE if the group box has a checkbox in its title; otherwise returns FALSE.[br]
		!fn: $setCheckable(<bool>)
		Sets whether the group box has a checkbox in its title: Valid values are 1 or 0.[br]
		!fn: $setInsideMargin(<number m>)
		Sets the the width of the inside margin to m pixels.[br]
		!fn: $insideMargin()
		Returns the width of the empty space between the items in the group and margin of groupbox.[br]
		!fn: $setInsideSpacing(<number m>)
		Sets the width of the empty space between each of the items in the group to m pixels.[br]
		!fn: $insideSpacing()
		Returns the width of the empty space between each of the items in the group.[br]
		!fn: $setColumns(<number>)
		Sets the number of columns or rows (depending of the orientation) in the group box.[br]
		!fn: $columns()
		Returns the number of columns or rows in the groupbox.[br]
		!fn: $addSpace()
		Adds an empty cell at the next free position.[br]
		!fn: $alignment()
		Returns the alignment of the group box title.[br]
		!fn: $setAlignment(<alignment>)
		Set the alignment of the groupbox;  Valid values are Left,Right,HCenter.[br]
		!fn: $setOrientation<orientation>
		Sets the group box's orientation. Valid values are: Horizontal, Vertical.[br]
		|----EXAMPLE----|[br]
		|-Start:[br]
		#Let's start.[br]
		#first we'll create the main widget.[br]
		%widget=$new(widget)[br]
		[br]
		#then the groupbox [br]
		%gb=$new(groupbox,%widget)[br]
		%gb->$setTitle(Login)[br]
		%gb->$setAlignment("Left")[br]
		[br]
		#now we create the labels and lineedits.[br]
		%labeluser=$new(label,%gb)[br]
		%labeluser->$settext(User: )[br]
		%labelpass=$new(label,%gb)[br]
		%labelpass->$settext(Pass: )[br]
		%inputuser=$new(lineedit,%gb)[br]
		%inputpass=$new(lineedit,%gb)[br]
		%inputpass->$setechomode("password")[br]
		[br]
		#now lets' layouting the groupbox's element's.[br]
		%layoutgb=$new(layout,%gb)[br]
		%layoutgb->$setmargin(20)[br]
		%layoutgb->$addwidget(%labeluser,0,0)[br]
		%layoutgb->$addwidget(%labelpass,1,0)[br]
		%layoutgb->$addwidget(%inputuser,0,1)[br]
		%layoutgb->$addwidget(%inputpass,1,1)[br]
		[br]
		# now we create a fake widget and managing the two buttons layout.[br]
		%fakewidget=$new(widget,%widget)[br]
		%layoutbtn=$new(layout,%fakewidget)[br]
		%btnok=$new(button,%fakewidget)[br]
		%btnok->$settext("OK")[br]
		%btncancel=$new(button,%fakewidget)[br]
		%btncancel->$settext("Cancel")[br]
		%layoutbtn->$addwidget(%btnok,0,0)[br]
		%layoutbtn->$addwidget(%btncancel,0,1)[br]
		[br]
		#And finally we create a main layout with the groupbox (and its "children")[br]
		#and fakewiget (with its buttons children).
		%mainlayout=$new(layout,%widget)[br]
		%mainlayout->$setspacing(10)[br]
		%mainlayout->$setmargin(10)[br]
		%mainlayout->$addwidget(%gb,0,0)[br]
		%mainlayout->$addwidget(%fakewidget,1,0)[br]
		[br]
		#Let's show our nice login request =D ! [br]
		%widget->$show()[br]
		|---End.[br]


*/

static KviScriptObjectClass * g_pGroupBoxClass = 0;

static KviScriptObject * GroupBoxClassCreateInstance(KviScriptObjectClass * c,
	KviScriptObject * p, const char * n)
{
	return new KviScriptGroupBoxObject(c, p, n);
}

KviScriptGroupBoxObject::KviScriptGroupBoxObject(KviScriptObjectClass * c, KviScriptObject * p,
	const char *n) : KviScriptWidgetObject(c, p, n)
{
}

KviScriptGroupBoxObject::~KviScriptGroupBoxObject()
{
}

bool KviScriptGroupBoxObject::init(KviCommand *)
{
	setObject(new QGroupBox(parentScriptWidget(), name()), true);
	return true;
}

#define grupboxFuncReg(__nam, __func) \
	g_pGroupBoxClass->registerFunctionHandler(__nam, \
	(KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptGroupBoxObject::__func)), \
	0, true);

void KviScriptGroupBoxObject::registerSelf()
{
	KviScriptObjectClass * base = g_pScriptObjectController-> \
		lookupClass("widget");
	__range_valid(base);

	g_pGroupBoxClass = new KviScriptObjectClass(base, "groupbox",
		GroupBoxClassCreateInstance, true);

	grupboxFuncReg("setTitle", functionsetTitle);
	grupboxFuncReg("title", functiontitle);
	grupboxFuncReg("setFlat", functionsetFlat);
	grupboxFuncReg("isFlat", functionisFlat);
	grupboxFuncReg("setCheckable", functionsetCheckable);
	grupboxFuncReg("isCheckable", functionisCheckable);
	grupboxFuncReg("setInsideMargin", functionsetInsideMargin);
	grupboxFuncReg("insideMargin", functioninsideMargin);
	grupboxFuncReg("setInsideSpacing", functionsetInsideSpacing);
	grupboxFuncReg("insideSpacing", functioninsideSpacing);
	grupboxFuncReg("setColumns", functionsetInsideMargin);
	grupboxFuncReg("columns", functioninsideMargin);
	grupboxFuncReg("addSpace", functionaddSpace);
	grupboxFuncReg("alignment", functionAlignment);
	grupboxFuncReg("setAlignment", functionSetAlignment);
	grupboxFuncReg("setOrientation", functionsetOrientation);
	grupboxFuncReg("isChecked", functionisChecked);
	grupboxFuncReg("setChecked", functionsetChecked);


}

void KviScriptGroupBoxObject::unregisterSelf()
{
	delete g_pGroupBoxClass;
    g_pGroupBoxClass = 0;
}

bool KviScriptGroupBoxObject::functionsetTitle(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"groupbox::setTitle");

	KviStr * pTitle = params->safeFirst();

	((QGroupBox *)widget())->setTitle(pTitle->ptr());

	return c->leaveStackFrame();
}

bool KviScriptGroupBoxObject::functiontitle(KviCommand *c,KviParameterList * p,KviStr &b)
{
	if(widget())
			b.append(((QGroupBox *)widget())->title());
	return true;
}

bool KviScriptGroupBoxObject::functionsetFlat(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QGroupBox *)widget())->setFlat(p->getBool());
	}
	return true;
}

bool KviScriptGroupBoxObject::functionisFlat(KviCommand *,KviParameterList * p,
	KviStr &b)
{

	if(widget())
	    b.append(((QGroupBox *) widget())->isFlat() ? '1' : '0');
	return true;
}

bool KviScriptGroupBoxObject::functionsetCheckable(KviCommand *,KviParameterList * p,
	KviStr &)
{
	if(widget())
	{
		((QGroupBox *)widget())->setCheckable(p->getBool());
	}
	return true;
}

bool KviScriptGroupBoxObject::functionisCheckable(KviCommand *,KviParameterList * p,
	KviStr &b)
{

	if(widget())
	    b.append(((QGroupBox *) widget())->isCheckable() ? '1' : '0');
	return true;
}


bool KviScriptGroupBoxObject::functionsetInsideMargin(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"layout::setInsideMargin");

	KviStr * pMargin = params->safeFirst();

	bool bOk;
	unsigned int uMargin = pMargin->toUInt(&bOk);
	if(!bOk)
	{
		c->warning(__tr("Invalid margin value (%s)"),pMargin->ptr());
		return c->leaveStackFrame();
	}

	((QGroupBox *)widget())->setInsideMargin(uMargin);

	return c->leaveStackFrame();
}

bool KviScriptGroupBoxObject::functioninsideMargin(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QGroupBox *)widget())->insideMargin());
	return true;
}
bool KviScriptGroupBoxObject::functionsetInsideSpacing(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"layout::setInsideSpacing");

	KviStr * pSpacing = params->safeFirst();

	bool bOk;
	unsigned int uSpacing = pSpacing->toUInt(&bOk);
	if(!bOk)
	{
		c->warning(__tr("Invalid spacing value (%s)"),pSpacing->ptr());
		return c->leaveStackFrame();
	}

	((QGroupBox *)widget())->setInsideSpacing(uSpacing);

	return c->leaveStackFrame();
}

bool KviScriptGroupBoxObject::functioninsideSpacing(KviCommand *c, KviParameterList *,	
	KviStr & b)
{
	if(widget())b.append(KviStr::Format,"%d",((QGroupBox *)widget())->insideSpacing());
	return true;
}

bool KviScriptGroupBoxObject::functionsetColumns(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"groupbox:setColumns");

	KviStr * pColumns = params->safeFirst();

	bool bOk;
	unsigned int uColumns = pColumns->toUInt(&bOk);
	if(!bOk)
	{
		c->warning(__tr("Invalid columns value (%s)"),pColumns->ptr());
		return c->leaveStackFrame();
	}

	((QGroupBox *)widget())->setColumns(uColumns);

	return c->leaveStackFrame();
}


bool KviScriptGroupBoxObject::functionaddSpace(KviCommand *c,KviParameterList * params,KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"layout::addCell");

	KviStr * pSpace = params->safeFirst();

	bool bOk;
	unsigned int uSpace = pSpace->toUInt(&bOk);
	if(!bOk)
	{
		c->warning(__tr("Invalid size value (%s)"),pSpace->ptr());
		return c->leaveStackFrame();
	}

	((QGroupBox *)widget())->addSpace(uSpace);

	return c->leaveStackFrame();
}

bool KviScriptGroupBoxObject::functionAlignment(KviCommand *, KviParameterList *,
	KviStr & b)
{
	if(widget())
	{
		KviStr ret;
		int align = ((QGroupBox *)widget())->alignment();
		for(unsigned int i = 0; i < align_num; i++)
		{
			if( align & align_cod[i] )
			{
				ret.append(align_tbl[i]);
				ret.append(",");
			}
		}
		ret.cutRight(1);	// cut last ","
		b.append(ret);
		return true;
	}
	b.append('0');
	return true;
}
//-->Functions to set allignment and orientation, see the tables on the top of code.
bool KviScriptGroupBoxObject::functionSetAlignment(KviCommand * c, KviParameterList * p,
	KviStr & b)
{
	if(!widget())
		return true;

	ENTER_STACK_FRAME(c, "grupbox::setAlignment");
	int cnt = p->count();
	int align;
	int sum = 0;
	for(int i = 0; i < cnt; i++)
	{
		align = 0;
		
		for(int j = 0; j < (int)align_num; j++ )
		{
			if(kvi_strEqualCI(p->at(i)->ptr(), align_tbl[j]))
			{
				align = align_cod[j];
				break;
			}
		}
		if(align)
			sum |= align;
		else
			c->warning( __tr("Unknown alignment: %s"), \
				p->at(i)->ptr());
	}
	((QGroupBox *)widget())->setAlignment(sum);
	return c->leaveStackFrame();
}



bool KviScriptGroupBoxObject::functionsetOrientation(KviCommand * c, KviParameterList * params,
	KviStr &buffer)
{
	ENTER_STACK_FRAME(c,"groupBox::setOrientation");
	KviStr * pModoS = params->safeFirst();
	QString modosoS = pModoS->ptr();
	if(widget())
	{

		if(modosoS=="Horizontal")
			((QGroupBox *)widget())->setOrientation(Qt::Horizontal);
		if(modosoS=="Vertical")
			((QGroupBox *)widget())->setOrientation(Qt::Vertical);
	}

	return true;
}

bool KviScriptGroupBoxObject::functionsetChecked(KviCommand *,KviParameterList * p, KviStr &)
{
	if(widget())
	{

		((QGroupBox *)widget())->setChecked(p->getBool());
	}

	return true;
}

bool KviScriptGroupBoxObject::functionisChecked(KviCommand *, KviParameterList *, KviStr & b)
{
	if(widget())
	{
		bool t = ((QGroupBox *)widget())->isChecked();
		b.append( t ? '1' : '0' );
	}
	return true;
}

#include "m_class_groupbox.moc"
