#ifndef	_CLASS_GROUPBOX_H_
#define	_CLASS_GROUPBOX_H_
//
//   File : class_groupbox.h
//   Creation date : Fri Jan 28 14:21:48 CEST 2005
//   by Tonino Imbesi(Grifisx) and Alessandro Carbone(Noldor)
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2005 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//



#include <qgroupbox.h>
#include "class_widget.h"

class KviScriptGroupBoxObject : public KviScriptWidgetObject
{
	Q_OBJECT
public:
	KviScriptGroupBoxObject(KviScriptObjectClass * c, KviScriptObject * p, 
		const char * n);
	virtual ~KviScriptGroupBoxObject();

	static void registerSelf();
	static void unregisterSelf();

protected:
	virtual bool init(KviCommand *);

	bool functionsetTitle(KviCommand *, KviParameterList *, KviStr &);
	bool functiontitle(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetFlat(KviCommand *, KviParameterList *, KviStr &);
	bool functionisFlat(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetCheckable(KviCommand *, KviParameterList *, KviStr &);
	bool functionisCheckable(KviCommand *, KviParameterList *, KviStr &); 
	bool functionsetInsideMargin(KviCommand *, KviParameterList *, KviStr &);
	bool functioninsideMargin(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetInsideSpacing(KviCommand *, KviParameterList *, KviStr &);
	bool functioninsideSpacing(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetColumns(KviCommand *, KviParameterList *, KviStr &);
	bool functioncolumns(KviCommand *, KviParameterList *, KviStr &);
	bool functionaddSpace(KviCommand *, KviParameterList *, KviStr &);
	bool functionAlignment(KviCommand *, KviParameterList *, KviStr &);
	bool functionSetAlignment(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetOrientation(KviCommand *, KviParameterList *, KviStr &);
	bool functionisChecked(KviCommand *, KviParameterList *, KviStr &);
	bool functionsetChecked(KviCommand *, KviParameterList *, KviStr &);

};

#endif	//!_CLASS_GROUPBOX_H_
