//
//   File : class_lcd.cpp
//   Creation date : Mon Gen 27 14:30:48 CEST 2005 by Tonino Imbesi(Grifisx)
//         and Alessandro Carbone(Noldor)
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "class_lcd.h"
#include "kvi_error.h"
#include "kvi_debug.h"
#include "kvi_command.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"

static KviScriptObjectClass * g_pLcdClass = 0;

static KviScriptObject * LcdClassCreateInstance(KviScriptObjectClass * c,
        KviScriptObject * p, const char * n)
{
        return new KviScriptLcdObject(c, p, n);
}

KviScriptLcdObject::KviScriptLcdObject(KviScriptObjectClass * c, KviScriptObject * p,
        const char *n) : KviScriptWidgetObject(c, p, n)
{
}

KviScriptLcdObject::~KviScriptLcdObject()
{
}

/*
	@doc: lcdnumber
	@keyterms:
		lcdnumber object class, lcd
	@title:
		lcdnumber class
	@type:
		class
	@short:
		The lcdNumber widget displays a number with LCD-like digits.
	@inherits:

	@description:
		It can display a number in just about any size. It can display decimal,
		hexadecimal, octal or binary numbers.
	@functions:
		!fn: $setDisplayStr(<string s>)
		Displays the number represented by the string s.
		!fn: $setDisplayInt(<number>)
		Sets the displayed value rounded to the nearest integer to number.
		!fn: $setDisplayDouble(<double number>)
		Sets the displayed value to number (double).
		!fn: $setMode(<mode>)
		Sets the current display mode (number base): valid mode are HEX,BIN,OCT,DEC.
		!fn: $setSegmentStyles(<style>)
		Sets the style of the lcdnumber, valid styles are: Outline,Filled,Flat.
		!fn: $setNumDigits(<number>)
		Sets the lcd number value.
		!fn: $checkOverflow()
		Returns TRUE if num is too big to be displayed in its entirety;
		otherwise returns FALSE. 
		!fn: $setSmallDecimalPoint(<bool>)
		Sets the the decimal point style, valid bool values are 1 or 0.
*/

bool KviScriptLcdObject::init(KviCommand *)
{
	setObject(new QLCDNumber(parentScriptWidget(), name()), true);
	return true;
}

#define LcdFuncReg(__nam, __func) \
        g_pLcdClass->registerFunctionHandler(__nam, \
        (KviScriptObjectFunctionHandlerProc)(KVI_PTR2MEMBER(KviScriptLcdObject::__func)), \
        0, true);

void KviScriptLcdObject::registerSelf()
{
        KviScriptObjectClass * base = g_pScriptObjectController-> \
                lookupClass("widget");
        __range_valid(base);

        g_pLcdClass = new KviScriptObjectClass(base, "Lcd", 
                LcdClassCreateInstance, true);

        LcdFuncReg("setDisplayStr", functionDisplay);
        LcdFuncReg("setDisplayInt", functionDisplayInt);
        LcdFuncReg("setDisplayDouble", functionDisplayInt);
        LcdFuncReg("setMode", functionsetMode);
        LcdFuncReg("setSegmentStyle", functionsetSegmentStyle);
        LcdFuncReg("setNumDigits", functionsetNumDigits);
        LcdFuncReg("setSmallDecimalPoint",functionsetSmallDecimalPoint);
        LcdFuncReg("checkOverflow", functioncheckOverflow);

}

void KviScriptLcdObject::unregisterSelf()
{
        delete g_pLcdClass;
    g_pLcdClass = 0;
}

bool KviScriptLcdObject::functionDisplay(KviCommand * c, KviParameterList * p, \
        KviStr & b)
{
        if(widget())
        {
                if(p->first())
                        ((QLCDNumber *)widget())->display(p->first()->ptr());
                else
                        ((QLCDNumber *)widget())->display("");
        }
        return true;

}

bool KviScriptLcdObject::functionDisplayInt(KviCommand * c, KviParameterList * p, \
        KviStr & b)
{
        ENTER_STACK_FRAME(c, "lcd::setDisplayInt");
        if(!widget())
            return c->leaveStackFrame(); 
        bool bOk;
        int val = p->getInt(&bOk);
        if(bOk)
            ((QLCDNumber *)widget())->display(val);
        else
            c->warning(__tr("Invalid  parameter"));
        return c->leaveStackFrame();

}

bool KviScriptLcdObject::functionDisplayDouble(KviCommand * c, KviParameterList * p, \
        KviStr & b)
{
        ENTER_STACK_FRAME(c, "lcd::setDisplayDouble");
        if(!widget())
            return c->leaveStackFrame(); 
        bool bOk;
        double val = p->getInt(&bOk);
        if(bOk)
            ((QLCDNumber *)widget())->display(val);
        else
            c->warning(__tr("Invalid  parameter"));
        return c->leaveStackFrame();

}

bool KviScriptLcdObject::functionsetMode(KviCommand * c, KviParameterList * params,
        KviStr &buffer)
{
        ENTER_STACK_FRAME(c,"lcd::setMode");
        KviStr * pModoS = params->safeFirst();
        QString modosoS = pModoS->ptr();
        if(widget())
        {

                if(modosoS=="HEX")
                        ((QLCDNumber *)widget())->setHexMode();
                if(modosoS=="DEC")
                        ((QLCDNumber *)widget())->setDecMode();
                if(modosoS=="BIN")
                        ((QLCDNumber *)widget())->setBinMode();
                if(modosoS=="OCT")
                        ((QLCDNumber *)widget())->setOctMode();
        }

        return true;
}

bool KviScriptLcdObject::functionsetSegmentStyle(KviCommand * c, KviParameterList * params,
        KviStr &buffer)
{
        ENTER_STACK_FRAME(c,"lcd::setSegmentStyle");
        KviStr * pModo = params->safeFirst();
        QString modoso = pModo->ptr();

        if(widget())
        {
                if(modoso=="Outline")
                        ((QLCDNumber *)widget())->setSegmentStyle(QLCDNumber::Outline);
                if(modoso=="Filled")
                        ((QLCDNumber *)widget())->setSegmentStyle(QLCDNumber::Filled);
                if(modoso=="Flat")
                        ((QLCDNumber *)widget())->setSegmentStyle(QLCDNumber::Flat);
        }
        return true;
}

bool KviScriptLcdObject::functionsetNumDigits(KviCommand *c,
        KviParameterList * p, KviStr & b)
{
        ENTER_STACK_FRAME(c, "lcd::setNumDigits");
        if(!widget())
            return c->leaveStackFrame(); 
        bool bOk;
        int val = p->getInt(&bOk);
        if(bOk)
            ((QLCDNumber *)widget())->setNumDigits(val);
        else
            c->warning(__tr("Invalid  parameter"));
        return c->leaveStackFrame();
}

bool KviScriptLcdObject::functionsetSmallDecimalPoint(KviCommand * c, KviParameterList * p,
        KviStr & b)
{
        if(widget())
        {
                ((QLCDNumber *)widget())->setSmallDecimalPoint(p->getBool());
        }
        return true;
}

bool KviScriptLcdObject::functioncheckOverflow(KviCommand * c, KviParameterList * p,
        KviStr & b)
{
        if(widget())
        {
                bool bOk;
                int val = p->getInt(&bOk);
                if(bOk)
                {
                        bool t = ((QLCDNumber *)widget())->checkOverflow(val);
                        b.append( t ? '1' : '0' );
                }
        }
        return true;
}



#include "m_class_lcd.moc"

