#ifndef        _CLASS_LCD_H_
#define        _CLASS_LCD_H_

//   File : class_lcd.h
//   Creation date : Mon Gen 27 14:30:48 CEST 2005 by Tonino Imbesi(Grifisx)
//         and Alessandro Carbone(Noldor)
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//



#include <qlcdnumber.h>
#include "class_widget.h"

class KviScriptLcdObject : public KviScriptWidgetObject
{
        Q_OBJECT
public:
        KviScriptLcdObject(KviScriptObjectClass * c, KviScriptObject * p, 
                const char * n);
        virtual ~KviScriptLcdObject();

        static void registerSelf();
        static void unregisterSelf();

protected:
        virtual bool init(KviCommand *);

        bool functionDisplay(KviCommand *, KviParameterList *, KviStr &);
        bool functionsetMode(KviCommand *, KviParameterList *, KviStr &);
        bool functionsetSegmentStyle(KviCommand *, KviParameterList *, KviStr &);
        bool functionsetNumDigits(KviCommand *, KviParameterList *, KviStr &);
        bool functionsetSmallDecimalPoint(KviCommand *, KviParameterList *, KviStr &);
        bool functioncheckOverflow(KviCommand *, KviParameterList * ,KviStr &);
        bool functionDisplayInt(KviCommand *, KviParameterList * ,KviStr &);
        bool functionDisplayDouble(KviCommand *, KviParameterList * ,KviStr &);
};

#endif        // !_CLASS_LCD_H_
