#ifndef _CLASS_LIST_H_
#define _CLASS_LIST_H_
//
//   File : class_list.h
//   Creation date : Wed Sep 09 2000 21:07:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_string.h"

#include "kvi_scriptobject.h"

#include "kvi_list.h"

class KviScriptListObject : public KviScriptObject
{
	Q_OBJECT
public:
	KviScriptListObject(KviScriptObjectClass * cla,KviScriptObject * par,const char * nam);
	virtual ~KviScriptListObject();

	KviPtrList<KviStr> * dataList() const	{ return m_pDataList; }
protected:
	KviPtrList<KviStr> * m_pDataList;
protected:
	bool functionCount(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionIsEmpty(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionInsert(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionAt(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionRemove(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionAppend(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionPrepend(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionRemoveFirst(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionRemoveLast(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionFirst(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionLast(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionNext(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionPrev(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionCurrent(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionCanIterate(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionClear(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionSort(KviCommand *c,KviParameterList * params,KviStr &buffer);
	bool functionFind(KviCommand *c,KviParameterList * params,KviStr &buffer);
public:
	static void registerSelf();
	static void unregisterSelf();
};


#endif //_CLASS_LIST_H_
